/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.settings.server;

import de.ponton.xmlpipe.rest.settings.server.ConnectorDto;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;

@Validated
@Schema(description="Holds the server configuration of the messenger.")
public class ServerDto {
    @NotNull
    @Size(min=1)
    @Valid
    @Schema(description="The connector configuration for the listeners, adapters and the GUI services. You can create several connectors.")
    private @NotNull @Size(min=1) @Valid List<@NotNull @Valid ConnectorDto> connectors;

    public List<ConnectorDto> getConnectors() {
        return this.connectors;
    }

    public ServerDto setConnectors(List<ConnectorDto> connectors) {
        this.connectors = new ArrayList<ConnectorDto>(connectors);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServerDto)) {
            return false;
        }
        ServerDto serverDto = (ServerDto)o;
        return Objects.equals(this.connectors, serverDto.connectors);
    }

    public int hashCode() {
        return Objects.hash(this.connectors);
    }

    public String toString() {
        return "ServerDto{connector=" + String.valueOf(this.connectors) + "}";
    }
}

