/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.settings.maintenance;

import com.fasterxml.jackson.annotation.JsonFormat;
import de.ponton.xmlpipe.rest.validation.EndDate;
import de.ponton.xmlpipe.rest.validation.StartDate;
import de.ponton.xmlpipe.rest.validation.ValidPeriodConstraint;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;

@Validated
@ValidPeriodConstraint
@Schema(description="Holds the maintenance configuration of the messenger. During a dedicated maintenance time window it is possible to deactivate certain functions")
public class MaintenancePeriodDto {
    @NotNull
    @StartDate
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
    @Schema(description="The start date and time of the maintenace period.")
    private OffsetDateTime startDate;
    @NotNull
    @EndDate
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
    @Schema(description="The end date and time of the maintenace period.")
    private OffsetDateTime endDate;
    @Schema(description="Incoming messages remain in inbound queue and will not be sent to adapters.")
    private boolean stopDeliveryToAdapters;
    @Schema(description="Outgoing messages remain in outbound queue and will not be sent to partners.")
    private boolean stopDeliveryToPartners;
    @Schema(description="No messages from partners are accepted by the messenger's listeners (internal components, not to be confused with separate listener software).")
    private boolean rejectIncomingMessages;
    @Schema(description="No messages from the backend adapters are accepted by the messenger.")
    private boolean rejectOutgoingMessages;

    public OffsetDateTime getStartDate() {
        return this.startDate;
    }

    public MaintenancePeriodDto setStartDate(OffsetDateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    public OffsetDateTime getEndDate() {
        return this.endDate;
    }

    public MaintenancePeriodDto setEndDate(OffsetDateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    public boolean isStopDeliveryToAdapters() {
        return this.stopDeliveryToAdapters;
    }

    public MaintenancePeriodDto setStopDeliveryToAdapters(boolean stopDeliveryToAdapters) {
        this.stopDeliveryToAdapters = stopDeliveryToAdapters;
        return this;
    }

    public boolean isStopDeliveryToPartners() {
        return this.stopDeliveryToPartners;
    }

    public MaintenancePeriodDto setStopDeliveryToPartners(boolean stopDeliveryToPartners) {
        this.stopDeliveryToPartners = stopDeliveryToPartners;
        return this;
    }

    public boolean isRejectIncomingMessages() {
        return this.rejectIncomingMessages;
    }

    public MaintenancePeriodDto setRejectIncomingMessages(boolean rejectIncomingMessages) {
        this.rejectIncomingMessages = rejectIncomingMessages;
        return this;
    }

    public boolean isRejectOutgoingMessages() {
        return this.rejectOutgoingMessages;
    }

    public MaintenancePeriodDto setRejectOutgoingMessages(boolean rejectOutgoingMessages) {
        this.rejectOutgoingMessages = rejectOutgoingMessages;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MaintenancePeriodDto)) {
            return false;
        }
        MaintenancePeriodDto that = (MaintenancePeriodDto)o;
        return this.stopDeliveryToAdapters == that.stopDeliveryToAdapters && this.stopDeliveryToPartners == that.stopDeliveryToPartners && this.rejectIncomingMessages == that.rejectIncomingMessages && this.rejectOutgoingMessages == that.rejectOutgoingMessages && Objects.equals(this.startDate, that.startDate) && Objects.equals(this.endDate, that.endDate);
    }

    public int hashCode() {
        return Objects.hash(this.startDate, this.endDate, this.stopDeliveryToAdapters, this.stopDeliveryToPartners, this.rejectIncomingMessages, this.rejectOutgoingMessages);
    }

    public String toString() {
        return "MaintenancePeriodDto{startDate=" + String.valueOf(this.startDate) + ", endDate=" + String.valueOf(this.endDate) + ", stopDeliveryToAdapters=" + this.stopDeliveryToAdapters + ", stopDeliveryToPartners=" + this.stopDeliveryToPartners + ", rejectIncomingMessages=" + this.rejectIncomingMessages + ", rejectOutgoingMessages=" + this.rejectOutgoingMessages + "}";
    }
}

