/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.settings.logging;

import de.ponton.xmlpipe.rest.settings.logging.LogLevel;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;

@Validated
@Schema(description="Holds the logging configuration of the messenger.")
public class LoggingDto {
    @NotNull
    @Schema(description="The logging level for the Messenger including all Message Processing. It is recommended, to use INFO level at maximum to avoid too much output.<ul><li>OFF turns logging off completely</li><li>...</li><li>TRACE logs all the messages output by the system</li></ul>Please note that the logging level can have an effect on the performance of your system. In particular, it is advisable to use DEBUG or TRACE logging only in connection with error tracking and analysis.")
    private LogLevel messengerLogLevel;
    @NotNull
    @Schema(description="The logging level for the JDBC/database access of the Messenger. It is recommended, to use INFO level at maximum to avoid too much output.<ul><li>OFF turns logging off completely</li><li>...</li><li>TRACE logs all the messages output by the system</li></ul>Please note that the logging level can have an effect on the performance of your system. In particular, it is advisable to use DEBUG or TRACE logging only in connection with error tracking and analysis.")
    private LogLevel jdbcLogLevel;
    @Schema(description="Logging all the message related events in the database reduces the performance but offers a better audit trail. This option allows to decide between maximum performance and maximum audit level.")
    private boolean logOnlyErrorsInDb;
    @NotNull
    @Min(value=1L)
    @Max(value=90L)
    @Schema(description="The number of days after ok event will be deleted automatically.")
    private @NotNull @Min(value=1L) @Max(value=90L) Integer okEventAge;

    public LogLevel getMessengerLogLevel() {
        return this.messengerLogLevel;
    }

    public LoggingDto setMessengerLogLevel(LogLevel messengerLogLevel) {
        this.messengerLogLevel = messengerLogLevel;
        return this;
    }

    public LogLevel getJdbcLogLevel() {
        return this.jdbcLogLevel;
    }

    public LoggingDto setJdbcLogLevel(LogLevel jdbcLogLevel) {
        this.jdbcLogLevel = jdbcLogLevel;
        return this;
    }

    public boolean isLogOnlyErrorsInDb() {
        return this.logOnlyErrorsInDb;
    }

    public LoggingDto setLogOnlyErrorsInDb(boolean logOnlyErrorsInDb) {
        this.logOnlyErrorsInDb = logOnlyErrorsInDb;
        return this;
    }

    public Integer getOkEventAge() {
        return this.okEventAge;
    }

    public LoggingDto setOkEventAge(Integer okEventAge) {
        this.okEventAge = okEventAge;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LoggingDto)) {
            return false;
        }
        LoggingDto that = (LoggingDto)o;
        return this.logOnlyErrorsInDb == that.logOnlyErrorsInDb && this.messengerLogLevel == that.messengerLogLevel && this.jdbcLogLevel == that.jdbcLogLevel && Objects.equals(this.okEventAge, that.okEventAge);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.messengerLogLevel, this.jdbcLogLevel, this.logOnlyErrorsInDb, this.okEventAge});
    }

    public String toString() {
        return "LoggingDto{messengerLogLevel=" + String.valueOf((Object)this.messengerLogLevel) + ", jdbcLogLevel=" + String.valueOf((Object)this.jdbcLogLevel) + ", logOnlyErrorsInDb=" + this.logOnlyErrorsInDb + ", okEventAge=" + this.okEventAge + "}";
    }
}

