/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.settings.email.notification.system;

import de.ponton.xmlpipe.rest.jackson.TrimmedField;
import de.ponton.xmlpipe.rest.settings.validation.EmailsFormatConstraint;
import de.pontonconsulting.xmlpipe.config.SystemEvent;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;

@Validated
@Schema(description="Holds the information about a system event receiver for the E-Mail notification configuration of the messenger.")
public class SystemEventReceiverDto {
    @NotNull
    @Size(max=256)
    @EmailsFormatConstraint
    @Schema(description="The email address to which the notification email will be sent.")
    @TrimmedField
    private @NotNull @Size(max=256) String email;
    @NotBlank
    @Size(max=256)
    @Schema(description="The subject of the email notification.")
    @TrimmedField
    private @NotBlank @Size(max=256) String subject;
    @NotNull
    @Size(min=1, max=1000)
    @Schema(description="A list of eventId's for which notification emails should be sent.")
    private @NotNull @Size(min=1, max=1000) List<@NotNull SystemEvent> messageEventIds;

    public String getEmail() {
        return this.email;
    }

    public SystemEventReceiverDto setEmail(String email) {
        this.email = email;
        return this;
    }

    public String getSubject() {
        return this.subject;
    }

    public SystemEventReceiverDto setSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public List<SystemEvent> getMessageEventIds() {
        return this.messageEventIds;
    }

    public SystemEventReceiverDto setMessageEventIds(List<SystemEvent> messageEventIds) {
        this.messageEventIds = new ArrayList<SystemEvent>(messageEventIds);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SystemEventReceiverDto)) {
            return false;
        }
        SystemEventReceiverDto that = (SystemEventReceiverDto)o;
        return Objects.equals(this.email, that.email) && Objects.equals(this.subject, that.subject) && Objects.equals(this.messageEventIds, that.messageEventIds);
    }

    public int hashCode() {
        return Objects.hash(this.email, this.subject, this.messageEventIds);
    }

    public String toString() {
        return "SystemEventReceiverDto{email='" + this.email + "', subject='" + this.subject + "', messageEventIds=" + String.valueOf(this.messageEventIds) + "}";
    }
}

