/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.settings.email.notification;

import de.ponton.xmlpipe.rest.settings.email.notification.CronExpressionDto;
import de.ponton.xmlpipe.rest.settings.email.notification.message.MessageEventReceiverDto;
import de.ponton.xmlpipe.rest.settings.email.notification.system.SystemEventReceiverDto;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;

@Validated
@Schema(description="Holds the email notification configuration of the messenger.")
public class EmailNotificationDto {
    @NotNull
    @Valid
    @Size(max=100)
    @Schema(description="You can use the notification service to send emails to one or more specified addresses whenever certain message events occur.")
    private @NotNull @Valid @Size(max=100) List<@NotNull @Valid MessageEventReceiverDto> messageEventReceivers;
    @NotNull
    @Valid
    @Size(max=100)
    @Schema(description="You can use the notification service to send emails to one or more specified addresses whenever certain system events occur.")
    private @NotNull @Valid @Size(max=100) List<@NotNull @Valid SystemEventReceiverDto> systemEventReceivers;
    @NotNull
    @Valid
    @Size(max=20)
    @Schema(description="One or more eMail notifications can be scheduled by using standard unix \"cron expressions\". If two time ranges are overlapping, then both send intervals will apply for the overlapping time range. Cron expressions are described at http://en.wikipedia.org/wiki/CRON_expression.")
    private @NotNull @Valid @Size(max=20) List<@NotNull @Valid CronExpressionDto> cronExpressions;

    public List<MessageEventReceiverDto> getMessageEventReceivers() {
        return this.messageEventReceivers;
    }

    public EmailNotificationDto setMessageEventReceivers(List<MessageEventReceiverDto> messageEventReceivers) {
        this.messageEventReceivers = new ArrayList<MessageEventReceiverDto>(messageEventReceivers);
        return this;
    }

    public List<SystemEventReceiverDto> getSystemEventReceivers() {
        return this.systemEventReceivers;
    }

    public EmailNotificationDto setSystemEventReceivers(List<SystemEventReceiverDto> systemEventReceivers) {
        this.systemEventReceivers = new ArrayList<SystemEventReceiverDto>(systemEventReceivers);
        return this;
    }

    public List<CronExpressionDto> getCronExpressions() {
        return this.cronExpressions;
    }

    public EmailNotificationDto setCronExpressions(List<CronExpressionDto> cronExpressions) {
        this.cronExpressions = new ArrayList<CronExpressionDto>(cronExpressions);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EmailNotificationDto)) {
            return false;
        }
        EmailNotificationDto that = (EmailNotificationDto)o;
        return Objects.equals(this.messageEventReceivers, that.messageEventReceivers) && Objects.equals(this.systemEventReceivers, that.systemEventReceivers) && Objects.equals(this.cronExpressions, that.cronExpressions);
    }

    public int hashCode() {
        return Objects.hash(this.messageEventReceivers, this.systemEventReceivers, this.cronExpressions);
    }

    public String toString() {
        return "EmailNotificationDto{messageEventReceiverDtos=" + String.valueOf(this.messageEventReceivers) + ", systemEventReceiverDtos=" + String.valueOf(this.systemEventReceivers) + ", cronExpressionDtos=" + String.valueOf(this.cronExpressions) + "}";
    }
}

