/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.settings.email.notification;

import de.ponton.xmlpipe.rest.jackson.TrimmedField;
import de.ponton.xmlpipe.rest.settings.validation.CronExpressionConstraint;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;

@Validated
@Schema(description="Holds the information about a cron expression for the E-Mail notification configuration of the messenger.")
public class CronExpressionDto {
    @NotNull
    @Size(max=256)
    @CronExpressionConstraint
    @Schema(description="The cron expression string.")
    @TrimmedField
    private @NotNull @Size(max=256) String cronExpression;
    @NotNull
    @Min(value=1L)
    @Schema(description="The maximum number of notifications per transmitted email. As a result there will be multiple eMails created if the limit per transmission is reached.")
    private @NotNull @Min(value=1L) Integer maxNotificationPerMail;

    public String getCronExpression() {
        return this.cronExpression;
    }

    public CronExpressionDto setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
        return this;
    }

    public Integer getMaxNotificationPerMail() {
        return this.maxNotificationPerMail;
    }

    public CronExpressionDto setMaxNotificationPerMail(Integer maxNotificationPerMail) {
        this.maxNotificationPerMail = maxNotificationPerMail;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CronExpressionDto)) {
            return false;
        }
        CronExpressionDto that = (CronExpressionDto)o;
        return Objects.equals(this.cronExpression, that.cronExpression) && Objects.equals(this.maxNotificationPerMail, that.maxNotificationPerMail);
    }

    public int hashCode() {
        return Objects.hash(this.cronExpression, this.maxNotificationPerMail);
    }

    public String toString() {
        return "CronExpressionDto{cronExpression='" + this.cronExpression + "', maxNotificationPerMail=" + this.maxNotificationPerMail + "}";
    }
}

