/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.settings.communication;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;

@Validated
@Schema(description="Holds the information about the retransmission of messages for the communication configuration of the messenger.")
public class RetransmissionDto {
    @NotNull
    @Min(value=0L)
    @Schema(description="Number of retries for the retransmission of a message.")
    private @NotNull @Min(value=0L) Integer numberOfRetries;
    @NotNull
    @Min(value=1L)
    @Schema(description="The interval in seconds at which the message is resent")
    private @NotNull @Min(value=1L) Integer retryInterval;

    public Integer getNumberOfRetries() {
        return this.numberOfRetries;
    }

    public RetransmissionDto setNumberOfRetries(Integer numberOfRetries) {
        this.numberOfRetries = numberOfRetries;
        return this;
    }

    public Integer getRetryInterval() {
        return this.retryInterval;
    }

    public RetransmissionDto setRetryInterval(Integer retryInterval) {
        this.retryInterval = retryInterval;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RetransmissionDto)) {
            return false;
        }
        RetransmissionDto that = (RetransmissionDto)o;
        return Objects.equals(this.numberOfRetries, that.numberOfRetries) && Objects.equals(this.retryInterval, that.retryInterval);
    }

    public int hashCode() {
        return Objects.hash(this.numberOfRetries, this.retryInterval);
    }

    public String toString() {
        return "RetransmissionDto{numberOfRetries=" + this.numberOfRetries + ", retryInterval=" + this.retryInterval + "}";
    }
}

