/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.settings.communication;

import de.ponton.xmlpipe.rest.jackson.TrimmedField;
import de.ponton.xmlpipe.rest.settings.communication.FtpProxyConfigDto;
import de.ponton.xmlpipe.rest.settings.communication.HttpProxyConfigDto;
import de.ponton.xmlpipe.rest.settings.communication.LdapProxyConfigDto;
import de.ponton.xmlpipe.rest.settings.communication.PingAllDto;
import de.ponton.xmlpipe.rest.settings.communication.RetransmissionDto;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;

@Validated
@Schema(description="Holds the communication configuration of the messenger.")
public class CommunicationDto {
    @NotNull
    @Valid
    @Schema(description="Here you can configure for how long the Messenger will try to send a message until it receives an acknowledgement. After (retries + 1) * interval the Messenger will give up.")
    private RetransmissionDto retransmission;
    @NotNull
    @Size(max=1024)
    @Schema(description="This value is used for Message IDs and Conversation IDs that are automatically generated by PontonXP. These generated IDs always look like 'xID-879384728933@yourdomain.com'. The ID domain in this example is 'yourdomain.com'.", example="yourdomain.com")
    @TrimmedField
    private @NotNull @Size(max=1024) String messageIdDomain;
    @Schema(description="Checks if the issuing CA of a Messenger's SSL certificate is known.")
    private boolean checkSslServerCert;
    @Schema(description=" If this option is activated, you can send messages from one local partner to another local partner.")
    private boolean allowLoopback;
    @Schema(description="Failed messages with expired TTL are reinserted into the outgoing queue at the same place.")
    private boolean requeueFailedMessages;
    @Schema(description="Check remote partner certificates for revocation every day and block revoked certificates.")
    private boolean partnerCertificateRevocationCheck;
    @NotNull
    @Valid
    @Schema(description="If this option is activated, EbXML Pings are continuously sent to all communication partners in defined time intervals. The results can be queried with the JMX interface.")
    private PingAllDto pingAll;
    @NotNull
    @Valid
    @Schema(description="This value is used to define the default adapter for the communication between partners. The default adapter is used in new agreements.")
    private String defaultAdapter;
    @Valid
    @Schema(description="If you are connected to the internet via a proxy, you must specify your proxy configuration here.")
    private HttpProxyConfigDto httpProxyConfig;
    @Valid
    @Schema(description="If you are connected to the internet via proxy, you must specify your proxy configuration here. The configuration is used for communication via FTP.")
    private FtpProxyConfigDto ftpProxyConfig;
    @Valid
    @Schema(description="If you are connected to the internet via proxy, you must specify your proxy configuration here. The configuration is used for communication via LDAP.")
    private LdapProxyConfigDto ldapProxyConfig;

    public RetransmissionDto getRetransmission() {
        return this.retransmission;
    }

    public CommunicationDto setRetransmission(RetransmissionDto retransmission) {
        this.retransmission = retransmission;
        return this;
    }

    public String getMessageIdDomain() {
        return this.messageIdDomain;
    }

    public CommunicationDto setMessageIdDomain(String messageIdDomain) {
        this.messageIdDomain = messageIdDomain;
        return this;
    }

    public boolean isCheckSslServerCert() {
        return this.checkSslServerCert;
    }

    public CommunicationDto setCheckSslServerCert(boolean checkSslServerCert) {
        this.checkSslServerCert = checkSslServerCert;
        return this;
    }

    public boolean isAllowLoopback() {
        return this.allowLoopback;
    }

    public CommunicationDto setAllowLoopback(boolean allowLoopback) {
        this.allowLoopback = allowLoopback;
        return this;
    }

    public boolean isRequeueFailedMessages() {
        return this.requeueFailedMessages;
    }

    public CommunicationDto setRequeueFailedMessages(boolean requeueFailedMessages) {
        this.requeueFailedMessages = requeueFailedMessages;
        return this;
    }

    public boolean isPartnerCertificateRevocationCheck() {
        return this.partnerCertificateRevocationCheck;
    }

    public CommunicationDto setPartnerCertificateRevocationCheck(boolean partnerCertificateRevocationCheck) {
        this.partnerCertificateRevocationCheck = partnerCertificateRevocationCheck;
        return this;
    }

    public PingAllDto getPingAll() {
        return this.pingAll;
    }

    public CommunicationDto setPingAll(PingAllDto pingAll) {
        this.pingAll = pingAll;
        return this;
    }

    public String getDefaultAdapter() {
        return this.defaultAdapter;
    }

    public CommunicationDto setDefaultAdapter(String defaultAdapter) {
        this.defaultAdapter = defaultAdapter;
        return this;
    }

    public HttpProxyConfigDto getHttpProxyConfig() {
        return this.httpProxyConfig;
    }

    public CommunicationDto setHttpProxyConfig(HttpProxyConfigDto httpProxyConfig) {
        this.httpProxyConfig = httpProxyConfig;
        return this;
    }

    public FtpProxyConfigDto getFtpProxyConfig() {
        return this.ftpProxyConfig;
    }

    public CommunicationDto setFtpProxyConfig(FtpProxyConfigDto ftpProxyConfig) {
        this.ftpProxyConfig = ftpProxyConfig;
        return this;
    }

    public LdapProxyConfigDto getLdapProxyConfig() {
        return this.ldapProxyConfig;
    }

    public CommunicationDto setLdapProxyConfig(LdapProxyConfigDto ldapProxyConfig) {
        this.ldapProxyConfig = ldapProxyConfig;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CommunicationDto)) {
            return false;
        }
        CommunicationDto that = (CommunicationDto)o;
        return this.checkSslServerCert == that.checkSslServerCert && this.allowLoopback == that.allowLoopback && this.requeueFailedMessages == that.requeueFailedMessages && Objects.equals(this.retransmission, that.retransmission) && Objects.equals(this.messageIdDomain, that.messageIdDomain) && Objects.equals(this.pingAll, that.pingAll) && Objects.equals(this.defaultAdapter, that.defaultAdapter) && Objects.equals(this.httpProxyConfig, that.httpProxyConfig) && Objects.equals(this.ftpProxyConfig, that.ftpProxyConfig) && Objects.equals(this.ldapProxyConfig, that.ldapProxyConfig);
    }

    public int hashCode() {
        return Objects.hash(this.retransmission, this.messageIdDomain, this.checkSslServerCert, this.allowLoopback, this.requeueFailedMessages, this.pingAll, this.defaultAdapter, this.httpProxyConfig, this.ftpProxyConfig, this.ldapProxyConfig);
    }

    public String toString() {
        return "CommunicationDto{retransmission=" + String.valueOf(this.retransmission) + ", messageIdDomain=" + this.messageIdDomain + ", checkSslServerCert=" + this.checkSslServerCert + ", allowLoopback=" + this.allowLoopback + ", requeueFailedMessages=" + this.requeueFailedMessages + ", pingAll=" + String.valueOf(this.pingAll) + ", defaultAdapter=" + this.defaultAdapter + ", httpProxyConfig=" + String.valueOf(this.httpProxyConfig) + ", ftpProxyConfig=" + String.valueOf(this.ftpProxyConfig) + ", ldapProxyConfig=" + String.valueOf(this.ldapProxyConfig) + "}";
    }
}

