/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.settings.adapterapi;

import de.ponton.xmlpipe.rest.jackson.TrimmedField;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import org.springframework.validation.annotation.Validated;

@Validated
@Schema(description="Holds the adapter api configuration of the messenger.")
public class AdapterApiDto {
    @Schema(description="Set to true to enabled the usage of the adapter api.")
    private boolean adapterApiEnabled;
    @NotNull
    @NotBlank
    @Schema(description="The IP of the adapter api.")
    @TrimmedField
    private String adapterApiAddress;
    @NotNull
    @Min(value=1L)
    @Max(value=65535L)
    @Schema(description="The port of the adapter api.")
    private @NotNull @Min(value=1L) @Max(value=65535L) int adapterApiPort;
    @NotNull
    @Min(value=5L)
    @Max(value=3600L)
    @Schema(description="Specifies the idle timeout in seconds. The default setting is 60 seconds.")
    private @NotNull @Min(value=5L) @Max(value=3600L) int adapterApiTimeout;

    public boolean isAdapterApiEnabled() {
        return this.adapterApiEnabled;
    }

    public AdapterApiDto setAdapterApiEnabled(boolean adapterApiEnabled) {
        this.adapterApiEnabled = adapterApiEnabled;
        return this;
    }

    public String getAdapterApiAddress() {
        return this.adapterApiAddress;
    }

    public AdapterApiDto setAdapterApiAddress(String adapterApiAddress) {
        this.adapterApiAddress = adapterApiAddress;
        return this;
    }

    public int getAdapterApiPort() {
        return this.adapterApiPort;
    }

    public AdapterApiDto setAdapterApiPort(int adapterApiPort) {
        this.adapterApiPort = adapterApiPort;
        return this;
    }

    public int getAdapterApiTimeout() {
        return this.adapterApiTimeout;
    }

    public AdapterApiDto setAdapterApiTimeout(int adapterApiTimeout) {
        this.adapterApiTimeout = adapterApiTimeout;
        return this;
    }
}

