/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.server.certificate;

import de.ponton.xmlpipe.rest.server.certificate.CreateServerCertificateRequestDto;
import de.ponton.xmlpipe.rest.server.certificate.ServerCertificateRequestDto;
import de.pontonconsulting.xmlpipe.Constants;
import de.pontonconsulting.xmlpipe.activation.ActivationControl;
import de.pontonconsulting.xmlpipe.admintool.InstallCertException;
import de.pontonconsulting.xmlpipe.admintool.messenger.ssl.certificate.KeyPairAlgorithm;
import de.pontonconsulting.xmlpipe.config.IServerConfigBean;
import de.pontonconsulting.xmlpipe.config.SSLKeystoreBean;
import de.pontonconsulting.xmlpipe.config.ServerSettings;
import de.pontonconsulting.xmlpipe.security.CertificateReader;
import de.pontonconsulting.xmlpipe.security.CertificateRequest;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.SecurityFileReader;
import de.pontonconsulting.xmlpipe.security.util.SignCertInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.operator.OperatorCreationException;
import org.springframework.security.core.context.SecurityContextHolder;

public class ServerCertificateService {
    public static final String SSL_TOMCAT_CERT_ALIAS = "tomcat";
    private static final String IPV4_PATTERN = "^(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(\\.(?!$)|$)){4}$";
    private static final String IPV6_PATTERN = "(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))";
    private static final Pattern ipv6_pattern = Pattern.compile("(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))");
    private static final Pattern ipv4_pattern = Pattern.compile("^(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(\\.(?!$)|$)){4}$");
    private final SSLKeystoreBean keystoreBean;
    private final CertificateUtility certificateUtility;
    private final CertificateReader certificate;
    private final SecurityFileReader securityFileReader;
    private final IServerConfigBean serverConfigBean;
    private final ActivationControl activationControl;

    public ServerCertificateService(SSLKeystoreBean keystoreBean, CertificateUtility certificateUtility, CertificateReader certificate, SecurityFileReader securityFileReader, IServerConfigBean serverConfigBean, ActivationControl activationControl) {
        this.keystoreBean = keystoreBean;
        this.certificateUtility = certificateUtility;
        this.certificate = certificate;
        this.securityFileReader = securityFileReader;
        this.serverConfigBean = serverConfigBean;
        this.activationControl = activationControl;
    }

    public Optional<X509Certificate> showServerCertificate() throws KeyStoreException {
        return Optional.ofNullable(this.keystoreBean.getSslCertificate(SSL_TOMCAT_CERT_ALIAS));
    }

    public void installKeystore(String keystore, String password) throws Exception {
        SignCertInfo signCertInfo = this.securityFileReader.getSignCertInfo(new ByteArrayInputStream(Base64.getDecoder().decode(keystore)), password);
        this.installCertificate(signCertInfo.getCertificateChain(), signCertInfo.getPrivateKey(), password);
    }

    public void installCertificate(X509Certificate certificate, String password) throws Exception {
        this.installCertificate(new X509Certificate[]{certificate}, null, password);
    }

    public void installCertificate(String certificate, String password) throws Exception {
        this.installCertificate(this.certificateUtility.getX509Certificate(certificate), password);
    }

    public void exportKeystore(ByteArrayOutputStream out, String password) throws GeneralSecurityException, IOException {
        X509Certificate certificate = this.keystoreBean.getSslCertificate(SSL_TOMCAT_CERT_ALIAS);
        Certificate[] certificateChain = this.keystoreBean.getSslCertificateChain(certificate);
        PrivateKey privateKey = this.keystoreBean.getSslPrivateKey(SSL_TOMCAT_CERT_ALIAS, password.toCharArray());
        this.certificateUtility.storePkcs12PrivateKey(!SSL_TOMCAT_CERT_ALIAS.equals(SSL_TOMCAT_CERT_ALIAS) ? this.buildAliasForCertificate(certificate) : SSL_TOMCAT_CERT_ALIAS, password, privateKey, certificateChain, out);
    }

    public String buildAliasForCertificate(X509Certificate certificate) throws CertificateEncodingException {
        return UUID.nameUUIDFromBytes(certificate.getEncoded()).toString().toLowerCase();
    }

    public ServerCertificateRequestDto certificateSignRequest(CreateServerCertificateRequestDto form) throws GeneralSecurityException, InstallCertException, OperatorCreationException, IOException {
        KeyPairAlgorithm keyPairAlgorithm = form.getAlgorithm();
        KeyPair keyPair = this.certificate.generateKeyPair(keyPairAlgorithm.getAlgorithm(), keyPairAlgorithm.getLength());
        CertificateRequest certRequest = this.createCertificateRequest(keyPair, form);
        this.storeKeyPair(form.getPassword(), keyPair, form);
        return new ServerCertificateRequestDto().setCertificateRequest(certRequest.getPEM()).setSubject(certRequest.getSubject()).setKeyPairAlgo(keyPairAlgorithm);
    }

    private void storeKeyPair(String password, KeyPair keyPair, CreateServerCertificateRequestDto form) throws GeneralSecurityException, OperatorCreationException {
        X500NameBuilder nameBuilder = new X500NameBuilder(X500Name.getDefaultStyle());
        nameBuilder.addRDN(BCStyle.CN, form.getCn());
        if (StringUtils.isNotBlank((CharSequence)form.getOu())) {
            nameBuilder.addRDN(BCStyle.OU, form.getOu());
        }
        nameBuilder.addRDN(BCStyle.O, form.getO());
        nameBuilder.addRDN(BCStyle.C, form.getC());
        X500Name issuer = nameBuilder.build();
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair.getPrivate();
        X509Certificate selfCert = this.certificate.createCertificate(issuer, publicKey, issuer, privateKey);
        this.keystoreBean.addTempPrivateKey(SSL_TOMCAT_CERT_ALIAS, privateKey, password.toCharArray(), selfCert);
    }

    private CertificateRequest createCertificateRequest(KeyPair keyPair, CreateServerCertificateRequestDto form) throws InstallCertException {
        try {
            X500NameBuilder nameBuilder = new X500NameBuilder(X500Name.getDefaultStyle());
            nameBuilder.addRDN(BCStyle.CN, form.getCn());
            if (StringUtils.isNotBlank((CharSequence)form.getOu())) {
                nameBuilder.addRDN(BCStyle.OU, form.getOu());
            }
            nameBuilder.addRDN(BCStyle.O, form.getO());
            if (StringUtils.isNotBlank((CharSequence)form.getL())) {
                nameBuilder.addRDN(BCStyle.L, form.getL());
            }
            if (StringUtils.isNotBlank((CharSequence)form.getSt())) {
                nameBuilder.addRDN(BCStyle.ST, form.getSt());
            }
            nameBuilder.addRDN(BCStyle.C, form.getC());
            nameBuilder.addRDN(BCStyle.EmailAddress, form.getEmail());
            if (StringUtils.isNotBlank((CharSequence)form.getPhone())) {
                nameBuilder.addRDN(BCStyle.TELEPHONE_NUMBER, form.getPhone());
            }
            X500Name subject = nameBuilder.build();
            HashMap<String, String> extensions = new HashMap();
            if (form.isExtensions()) {
                extensions = this.buildExtensions();
            }
            return new CertificateRequest(this.certificateUtility.generateTempAlias(), subject, extensions, keyPair.getPublic(), keyPair.getPrivate(), new GeneralNames(form.getSan().stream().map(this::createGeneralName).collect(Collectors.toList()).toArray(new GeneralName[0])));
        }
        catch (GeneralSecurityException | OperatorCreationException e) {
            InstallCertException ce = new InstallCertException(32013, new String[]{e.getMessage()}, e.getMessage());
            ce.setStackTrace(e.getStackTrace());
            throw ce;
        }
    }

    private GeneralName createGeneralName(String value) {
        return ipv6_pattern.matcher(value).matches() || ipv4_pattern.matcher(value).matches() ? new GeneralName(7, value) : new GeneralName(2, value);
    }

    private Map<String, String> buildExtensions() {
        HashMap<String, String> extensions = new HashMap<String, String>(3);
        extensions.put("1.3.6.1.4.1.14136.3.1", Constants.getXP_VERSION());
        String testValue = this.activationControl.isLicensed() ? "false" : "true";
        extensions.put("1.3.6.1.4.1.14136.3.2", testValue);
        extensions.put("1.3.6.1.4.1.14136.3.3", "ssl");
        return extensions;
    }

    private void installCertificate(Certificate[] certificates, PrivateKey key, String password) throws Exception {
        X509Certificate[] chain;
        PrivateKey tempPrivateKey;
        for (int i = certificates.length; i > 1; --i) {
            X509Certificate cert = (X509Certificate)certificates[i - 1];
            String SSL_TOMCAT_CERT_ALIAS = this.certificateUtility.buildAliasForCA(cert);
            this.keystoreBean.addSslCA(SSL_TOMCAT_CERT_ALIAS, cert);
        }
        X509Certificate cert = (X509Certificate)certificates[0];
        if (cert == null) {
            throw new InstallCertException(32001, "Certificate format not recognized");
        }
        this.keystoreBean.checkCertificate(cert);
        X509Certificate installedCertificate = this.keystoreBean.getSslCertificate(SSL_TOMCAT_CERT_ALIAS);
        if (installedCertificate != null && this.certificateUtility.certificatesEqual(cert, installedCertificate)) {
            throw new InstallCertException(32017, "Certificate is already installed.");
        }
        if (key == null) {
            tempPrivateKey = this.getTempPrivateKey(password);
            this.verifyPublicKey(cert);
            chain = this.keystoreBean.getSslCertificateChain(cert);
        } else {
            tempPrivateKey = key;
            chain = new X509Certificate[certificates.length];
            for (int i = 0; i < chain.length; ++i) {
                chain[i] = (X509Certificate)certificates[i];
            }
        }
        this.keystoreBean.addSslPrivateKey(SSL_TOMCAT_CERT_ALIAS, tempPrivateKey, password.toCharArray(), chain);
        Map<String, ServerSettings> connectors = this.serverConfigBean.getConnectors();
        if (connectors != null) {
            ArrayList<ServerSettings> serverSettings = new ArrayList<ServerSettings>(connectors.size());
            for (String id : connectors.keySet()) {
                ServerSettings connector = connectors.get(id);
                serverSettings.add(connector);
                if (!connector.isSsl()) continue;
                connector.setSslKeyPassword(password);
            }
            this.serverConfigBean.setConnectors(serverSettings);
            if (SecurityContextHolder.getContext() != null && SecurityContextHolder.getContext().getAuthentication() != null) {
                this.serverConfigBean.save(SecurityContextHolder.getContext().getAuthentication().getName());
            } else {
                this.serverConfigBean.save();
            }
        }
        this.keystoreBean.deleteTempPrivateKey(SSL_TOMCAT_CERT_ALIAS);
        this.keystoreBean.initialize();
    }

    private PrivateKey getTempPrivateKey(String password) throws GeneralSecurityException, InstallCertException {
        PrivateKey tempPrivateKey = null;
        try {
            tempPrivateKey = this.keystoreBean.getTempPrivateKey(SSL_TOMCAT_CERT_ALIAS, password.toCharArray());
        }
        catch (GeneralSecurityException e) {
            throw new InstallCertException(32002, "Wrong password. You must supply the password for your private key.");
        }
        if (tempPrivateKey == null) {
            throw new InstallCertException(32003, "No matching private key found for local ID. A certificate must be requested first.");
        }
        return tempPrivateKey;
    }

    private void verifyPublicKey(X509Certificate certificate) throws GeneralSecurityException, InstallCertException {
        Certificate[] tempCert = this.keystoreBean.getSslTempCertificateChain(SSL_TOMCAT_CERT_ALIAS);
        if (!certificate.getPublicKey().equals(tempCert[0].getPublicKey())) {
            throw new InstallCertException(32004, "Public key generated when requesting the certificate does not match with signed public key from certificate.");
        }
    }
}

