/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.plugableadaptersettings;

import de.ponton.xmlpipe.rest.plugableadaptersettings.PlugableAdapterConfigDto;
import de.ponton.xmlpipe.rest.plugableadaptersettings.PlugableAdapterConfigFactory;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.PlugableAdapterConfig;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerAddOnDAO;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class PlugableAdapterConfigService {
    private final MessengerAddOnDAO messengerAddOnDAO;
    private final PlugableAdapterConfigFactory plugableAdapterConfigFactory;
    private final ReferenceDateTask referenceDateTask;

    public PlugableAdapterConfigService(MessengerAddOnDAO messengerAddOnDAO, PlugableAdapterConfigFactory plugableAdapterConfigFactory, ReferenceDateTask referenceDateTask) {
        this.messengerAddOnDAO = messengerAddOnDAO;
        this.plugableAdapterConfigFactory = plugableAdapterConfigFactory;
        this.referenceDateTask = referenceDateTask;
    }

    public List<PlugableAdapterConfigDto> getAllPlugableAdapterConfigs() {
        return this.messengerAddOnDAO.loadAllPlugableAdapterConfigs().stream().map(this.plugableAdapterConfigFactory::create).collect(Collectors.toList());
    }

    public void storePlugableAdapterConfig(String filename, InputStream inputStream) throws IOException {
        this.messengerAddOnDAO.storePlugableAdapterConfig(new PlugableAdapterConfig().setFilename(filename).setTimestamp(this.referenceDateTask.getReferenceOffsetDateTime()).setData(inputStream.readAllBytes()));
    }

    public void deletePlugableAdapterConfig(String filename) {
        this.messengerAddOnDAO.deletePlugableAdapterConfig(filename);
    }

    public void readPlugableAdapterConfig(String filename, OutputStream outputStream) throws IOException {
        Optional<PlugableAdapterConfig> config = this.messengerAddOnDAO.loadPlugableAdapterConfig(filename);
        if (!config.isPresent()) {
            throw new IOException("Plugable adapter config not found or empty: " + filename);
        }
        outputStream.write(config.get().getData());
        outputStream.flush();
    }
}

