/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.messagetype;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.ponton.xmlpipe.rest.jackson.TrimmedField;
import de.ponton.xmlpipe.rest.validation.ValidationGroup;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Null;
import org.springframework.validation.annotation.Validated;

@Validated
@Schema(description="Describes the type of a message")
public class MessageTypeDto {
    @Null(groups={ValidationGroup.Create.class})
    @NotBlank(groups={ValidationGroup.Read.class})
    @Schema(description="The unique id of the message type")
    @TrimmedField
    private String id;
    @NotBlank
    @Schema(description="The name of the schema set used in the message type")
    @JsonProperty(value="schemaSet")
    @TrimmedField
    private String schemaSetName;
    @NotBlank
    @Schema(description="The message type name")
    @TrimmedField
    private String messageType;
    @NotBlank
    @Schema(description="The message type version")
    @TrimmedField
    private String messageVersion;
    @NotBlank
    @Schema(description="The schema location of the message type")
    @JsonProperty(value="schemaLocation")
    @TrimmedField
    private String name;
    @Schema(description="The namespace of the message type")
    @TrimmedField
    private String namespace;

    public String getId() {
        return this.id;
    }

    public MessageTypeDto setId(String id) {
        this.id = id;
        return this;
    }

    public String getSchemaSetName() {
        return this.schemaSetName;
    }

    public MessageTypeDto setSchemaSetName(String schemaSetName) {
        this.schemaSetName = schemaSetName;
        return this;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public MessageTypeDto setMessageType(String messageType) {
        this.messageType = messageType;
        return this;
    }

    public String getMessageVersion() {
        return this.messageVersion;
    }

    public MessageTypeDto setMessageVersion(String messageVersion) {
        this.messageVersion = messageVersion;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public MessageTypeDto setName(String name) {
        this.name = name;
        return this;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public MessageTypeDto setNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }
}

