/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.messagemonitor;

import de.ponton.xmlpipe.rest.messagemonitor.MessageFilterDto;
import de.ponton.xmlpipe.rest.messagemonitor.MessageMonitorService;
import de.ponton.xmlpipe.rest.messagemonitor.MessageResendException;
import de.pontonconsulting.xmlpipe.config.FoldersProvider;
import de.pontonconsulting.xmlpipe.config.IFolders;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.message.XpMessageAttachment;
import de.pontonconsulting.xmlpipe.message.signals.XpSignal;
import de.pontonconsulting.xmlpipe.messenger.IdGenerator;
import de.pontonconsulting.xmlpipe.messenger.MessageRegistrationService;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.SendToListener;
import de.pontonconsulting.xmlpipe.messenger.SendToListenerResult;
import de.pontonconsulting.xmlpipe.messenger.archive.ArchiveProcessor;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.MessageInfo;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.Message;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.XpDatabaseMessage;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import de.pontonconsulting.xmlpipe.messenger.filter.MessageRecognitionException;
import de.pontonconsulting.xmlpipe.messenger.service.AdapterService;
import de.pontonconsulting.xmlpipe.messenger.service.FileService;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Root;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.Principal;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class MessageResendService {
    private final IFolders folders;
    private final ReferenceDateTask referenceDateTask;
    private final FileService fileService;
    private final SendToListener sendToListener;
    private final MessageDAO messageDAO;
    private final ExecutorService restExecutorService;
    private final MessageMonitorService messageMonitorService;
    private final AdapterService adapterService;
    private final MessageRegistrationService messageRegistrationService;
    private final ArchiveProcessor archiveProcessor;
    private final MessengerConfig messengerConfig;
    private final Logger log = LogManager.getLogger((String)("Messenger." + this.getClass().getSimpleName()));
    private final AtomicBoolean busy = new AtomicBoolean();
    private final IdGenerator idGenerator;

    public MessageResendService(IFolders folders, ReferenceDateTask referenceDateTask, FileService fileService, SendToListener sendToListener, MessageDAO messageDAO, @Qualifier(value="restExecutorService") ExecutorService restExecutorService, MessageMonitorService messageMonitorService, AdapterService adapterService, MessageRegistrationService messageRegistrationService, IdGenerator idGenerator, ArchiveProcessor archiveProcessor, MessengerConfig messengerConfig) {
        this.folders = folders;
        this.referenceDateTask = referenceDateTask;
        this.fileService = fileService;
        this.sendToListener = sendToListener;
        this.messageDAO = messageDAO;
        this.restExecutorService = restExecutorService;
        this.messageMonitorService = messageMonitorService;
        this.adapterService = adapterService;
        this.messageRegistrationService = messageRegistrationService;
        this.idGenerator = idGenerator;
        this.archiveProcessor = archiveProcessor;
        this.messengerConfig = messengerConfig;
    }

    protected SendToListenerResult createCopyAndResendMessage(MessageInfo info) throws IOException, DbException {
        XpMessage xpMessage = this.restoreXpMessage(info);
        XpMessage tempMessage = this.messageRegistrationService.registerMessageFromAdapter(info.getAdapterId());
        Date newMessageTime = this.referenceDateTask.getReferenceDate();
        String newMessageId = this.idGenerator.generateMessageId();
        xpMessage.setMessageId(newMessageId);
        xpMessage.setDatabaseId(tempMessage.getDatabaseId());
        this.copyDataToWorkFolderAndSetNewMessageTime(info, String.valueOf(tempMessage.getDatabaseId()), newMessageTime, xpMessage);
        try {
            return this.sendToListener.handleMessage(xpMessage, info.getDatabaseId());
        }
        catch (MessageRecognitionException e) {
            this.messageRegistrationService.logErrorAndSetFailedStatus(xpMessage, e.getMessage());
            return new SendToListenerResult(SendToListenerResult.Result.COULD_NOT_PROCESS_MESSAGE, xpMessage, e.getMessage());
        }
    }

    protected SendToListenerResult copyFromArchiveAndResendMessage(MessageInfo info) throws IOException, DbException {
        XpMessage xpMessage = this.restoreXpMessage(info);
        String workFolderName = String.valueOf(info.getDatabaseId());
        Date newMessageTime = this.referenceDateTask.getReferenceDate();
        this.copyDataToWorkFolderAndSetNewMessageTime(info, workFolderName, newMessageTime, xpMessage);
        this.messageDAO.updateMessageTimeStamp(xpMessage.getDatabaseId());
        this.messageDAO.removeAckReceived(xpMessage.getDatabaseId());
        try {
            return this.sendToListener.handleMessage(xpMessage);
        }
        catch (MessageRecognitionException e) {
            this.messageRegistrationService.logErrorAndSetFailedStatus(xpMessage, e.getMessage());
            return new SendToListenerResult(SendToListenerResult.Result.COULD_NOT_PROCESS_MESSAGE, xpMessage, e.getMessage());
        }
    }

    private XpMessage restoreXpMessage(MessageInfo info) throws IOException, DbException {
        XpDatabaseMessage xpDatabaseMessage = this.messageDAO.loadXpDatabaseMessage(info.getDatabaseId());
        if (Objects.nonNull(xpDatabaseMessage)) {
            return this.convertToXpMessage(xpDatabaseMessage, this.messengerConfig.getMessengerId());
        }
        Optional<XpMessage> xpMessageFromArchive = this.archiveProcessor.getXpMessageFromArchive(info);
        if (xpMessageFromArchive.isPresent()) {
            return xpMessageFromArchive.get();
        }
        throw new FileNotFoundException("Can't load XpMessage from archive for message " + info.getDatabaseId());
    }

    private void copyDataToWorkFolderAndSetNewMessageTime(MessageInfo info, String workFolderName, Date newMessageTime, XpMessage xpMessage) throws IOException {
        if (info.getPayloadFile() != null) {
            xpMessage.setCurrentContentReference(info.getPayloadFile());
        }
        File outboundMessageFolder = new File(this.folders.getWorkOutboundFolder(), workFolderName);
        Files.createDirectories(outboundMessageFolder.toPath(), new FileAttribute[0]);
        this.fileService.copyMessageDataToFolder(xpMessage, info, outboundMessageFolder);
        xpMessage.setMessageTimestamp(newMessageTime);
    }

    public void resendFailedMessage(Long databaseId) throws DbException, IOException, ClassNotFoundException, MessageResendException {
        MessageInfo info = this.messageDAO.getMessageInfo(databaseId);
        if (info == null || info.getStatus() != 4) {
            throw new IllegalStateException("incorrect message state");
        }
        if (info.isInbound()) {
            throw new IllegalStateException("inbound message");
        }
        SendToListenerResult result = this.copyFromArchiveAndResendMessage(info);
        if (result.getResult() != SendToListenerResult.Result.MSG_SUCCESSFULLY_SENT) {
            throw new MessageResendException(result.getDetails(), result.getResult());
        }
    }

    public void resendSuccessfulMessage(Long databaseId) throws DbException, IOException, ClassNotFoundException, MessageResendException {
        MessageInfo info = this.messageDAO.getMessageInfo(databaseId);
        if (info == null || info.getStatus() != 3) {
            throw new IllegalStateException("incorrect message state");
        }
        if (info.isInbound()) {
            throw new IllegalStateException("inbound message");
        }
        SendToListenerResult result = this.createCopyAndResendMessage(info);
        if (result.getResult() != SendToListenerResult.Result.MSG_SUCCESSFULLY_SENT) {
            throw new MessageResendException(result.getDetails(), result.getResult());
        }
    }

    public boolean toggleMessageStatus(Long databaseId) throws DbException {
        MessageInfo messageInfo = this.messageDAO.getMessageInfo(databaseId);
        if (messageInfo == null) {
            return false;
        }
        switch (messageInfo.getStatus()) {
            case 6: {
                this.messageDAO.updateMessageStatus((long)databaseId, messageInfo.getMessageId(), 4);
                break;
            }
            case 4: {
                this.messageDAO.updateMessageStatus((long)databaseId, messageInfo.getMessageId(), 6);
                break;
            }
            default: {
                throw new IllegalStateException("Cannot toggle status different from RESOLVED and FAILED");
            }
        }
        return true;
    }

    public void resendFailedMessages(MessageFilterDto filter, Principal principal) {
        if (this.busy.get()) {
            throw new IllegalStateException("Already re-sending failed messages");
        }
        this.busy.set(true);
        this.restExecutorService.submit(() -> {
            try {
                this.messageDAO.batchMessagesOperation((criteriaBuilder, root) -> this.messageMonitorService.preparePredicates((CriteriaBuilder)criteriaBuilder, (Root<Message>)root, filter, principal), messageInfo -> {
                    try {
                        MessageDAO.putDbIdToThreadContext(messageInfo.getDatabaseId());
                        if (!messageInfo.isInbound()) {
                            this.copyFromArchiveAndResendMessage((MessageInfo)messageInfo);
                        } else if (!StringUtils.isEmpty((CharSequence)messageInfo.getAdapterId())) {
                            this.adapterService.changeAdapter(principal.getName(), messageInfo.getDatabaseId(), messageInfo.getAdapterId());
                        }
                    }
                    catch (Exception e) {
                        if (this.log.isDebugEnabled()) {
                            this.log.error(e.getMessage(), (Throwable)e);
                        }
                        this.log.error(e.getMessage());
                    }
                });
            }
            catch (DbException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.error(e.getMessage(), (Throwable)e);
                } else {
                    this.log.error(e.getMessage());
                }
            }
            finally {
                this.busy.set(false);
            }
        });
    }

    XpMessage convertToXpMessage(XpDatabaseMessage xpDbMessage, int fallbackMessengerId) {
        XpMessage xpMessage;
        if ("ErrorNotification".equals(xpDbMessage.getMessageType())) {
            xpMessage = new XpSignal();
            ((XpSignal)xpMessage).setErrorNotification(true);
        } else {
            xpMessage = new XpMessage();
        }
        xpMessage.setDatabaseId(xpDbMessage.getId());
        xpMessage.setMessageId(xpDbMessage.getMessageId());
        xpMessage.setCurrentContentReferenceFolder(Objects.isNull(xpDbMessage.getFolder()) ? null : FoldersProvider.convertStringToFolder(xpDbMessage.getFolder()));
        xpMessage.setMessageTimestamp(Objects.isNull(xpDbMessage.getCreationTime()) ? null : new Date(xpDbMessage.getCreationTime()));
        xpMessage.setInboundMessage(xpDbMessage.getInbound());
        xpMessage.setInternalSequenceNumber(Optional.ofNullable(xpDbMessage.getSequenceNumber()).orElse(-1L));
        xpMessage.setMessageType(xpDbMessage.getMessageType());
        xpMessage.setMessageVersion(xpDbMessage.getSchemaVersion());
        xpMessage.setSchemaSet(xpDbMessage.getSchemaSet());
        xpMessage.setProtocol(xpDbMessage.getProtocol());
        xpMessage.setReceiverLocalId(xpDbMessage.getReceiverLocalId());
        xpMessage.setSenderLocalId(xpDbMessage.getSenderLocalId());
        xpMessage.setRegistrationTimestamp(Objects.isNull(xpDbMessage.getMessageTime()) ? null : new Date(xpDbMessage.getMessageTime()));
        xpMessage.setTimeToLive(Objects.isNull(xpDbMessage.getTtl()) || xpDbMessage.getTtl() == -1L ? null : new Date(xpDbMessage.getTtl()));
        xpMessage.setMessagePackaging(xpDbMessage.getPackageId());
        xpMessage.setSignedAckRequested(xpDbMessage.getSignedAckRequested());
        xpMessage.setTestMessage(xpDbMessage.isTestMessage());
        xpMessage.setAdapterId(xpDbMessage.getAdapterId());
        xpMessage.setMessengerId(Optional.ofNullable(xpDbMessage.getMessengerId()).orElse(fallbackMessengerId));
        xpMessage.setIsAck(xpDbMessage.isAck());
        xpMessage.setAckRequested(xpDbMessage.isAckRequested());
        String contentReference = xpDbMessage.getContentReference();
        if (Objects.nonNull(contentReference)) {
            xpMessage.setCurrentContentReference(new File(xpDbMessage.getFolder(), contentReference));
        }
        xpMessage.setCurrentContentType(xpDbMessage.getContentType());
        xpMessage.setDestinationUrl(xpDbMessage.getDestinationUrl());
        xpMessage.setIsStatusResponse(Boolean.parseBoolean(xpDbMessage.getProcessingDirective("IsStatusResponse")));
        xpMessage.setSchemaLocation(xpDbMessage.getSchemaLocation());
        xpMessage.setSchemaNamespace(xpDbMessage.getSchemaNamespace());
        xpMessage.setTransferId(xpDbMessage.getTransferId());
        xpMessage.setSenderInternalId(xpDbMessage.getSenderInternalId());
        xpMessage.setReceiverInternalId(xpDbMessage.getReceiverInternalId());
        if (!xpDbMessage.getAttachments().isEmpty()) {
            File workFolder = new File(xpDbMessage.getFolder());
            xpDbMessage.getAttachments().forEach(at -> {
                XpMessageAttachment attachment = new XpMessageAttachment(at.resolveAttachmentFile(workFolder), at.getMimeType(), at.getDescription(), at.getLanguage());
                attachment.setRole(at.getRole());
                xpMessage.addAttachment(attachment);
            });
        }
        xpDbMessage.getProcessingDirectives().values().forEach(pd -> xpMessage.setProcessingDirective(pd.getType(), pd.getValue()));
        xpMessage.setReferenceDatabaseId(xpDbMessage.getReferenceId());
        xpMessage.setReferenceId(xpDbMessage.getReferenceMessageId());
        xpMessage.setConversationDatabaseId(xpDbMessage.getConversationDbId());
        xpMessage.setConversationId(xpDbMessage.getConversationId());
        return xpMessage;
    }
}

