/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.messagemonitor;

import de.ponton.xmlpipe.queue.InboundQueue;
import de.ponton.xmlpipe.queue.OutboundQueue;
import de.ponton.xmlpipe.queue.QueueMessageConsumer;
import de.pontonconsulting.xmlpipe.messenger.archive.ArchiveProcessor;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.MessageInfo;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import java.io.File;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.FileSystemUtils;

@Component
public class MessageQueueService {
    private static final Logger log = LogManager.getLogger((String)("Messenger." + MessageQueueService.class.getName()));
    private final ArchiveProcessor archiveProcessor;
    private final InboundQueue inboundMessageQueue;
    private final OutboundQueue outboundMessageQueue;
    private final MessageDAO messageDao;
    private final MessengerLog messengerLog;
    private final QueueMessageConsumer inboundMessageConsumer;

    public MessageQueueService(ArchiveProcessor archiveProcessor, InboundQueue inboundMessageQueue, OutboundQueue outboundMessageQueue, MessageDAO messageDao, MessengerLog messengerLog, @Qualifier(value="inboundQueueMessageConsumer") QueueMessageConsumer inboundMessageConsumer) {
        this.archiveProcessor = archiveProcessor;
        this.inboundMessageQueue = inboundMessageQueue;
        this.outboundMessageQueue = outboundMessageQueue;
        this.messageDao = messageDao;
        this.messengerLog = messengerLog;
        this.inboundMessageConsumer = inboundMessageConsumer;
    }

    public boolean deleteMessageFromQueue(long messageDataId) {
        try {
            MessageInfo messageInfo = this.messageDao.getMessageInfo(messageDataId);
            if (messageInfo != null) {
                if (messageInfo.isInbound()) {
                    this.deleteMessageFromInboundQueue(messageInfo);
                } else {
                    this.deleteMessageFromOutboundQueue(messageInfo);
                }
                return true;
            }
        }
        catch (DbException e) {
            log.error("Could not load message info from database", (Throwable)e);
        }
        return false;
    }

    private void deleteMessageFromInboundQueue(MessageInfo messageInfo) {
        if (!this.inboundMessageConsumer.interruptDelivery(messageInfo.getDatabaseId())) {
            this.inboundMessageQueue.deleteFromInboundQueue(messageInfo.getDatabaseId());
            this.updateMessageStatusAndArchive(messageInfo);
        }
    }

    private void deleteMessageFromOutboundQueue(MessageInfo messageInfo) {
        if (!this.outboundMessageQueue.cancelIfInTransfer(messageInfo.getDatabaseId())) {
            try {
                this.outboundMessageQueue.deleteFromOutboundQueue(messageInfo.getDatabaseId());
            }
            catch (DbException e) {
                log.error("Could not delete message from outbound queue", (Throwable)e);
            }
            this.updateMessageStatusAndArchive(messageInfo);
        }
    }

    private void updateMessageStatusAndArchive(MessageInfo messageInfo) {
        this.messengerLog.log2db(212, messageInfo.getDatabaseId(), "");
        FileSystemUtils.deleteRecursively((File)messageInfo.getMessageFolder());
        this.archiveProcessor.sendFilesToArchive(messageInfo.getDatabaseId(), true);
        this.messageDao.updateMessageStatus(messageInfo.getDatabaseId(), messageInfo.getMessageId(), 4);
    }
}

