/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.messagemonitor;

import com.fasterxml.jackson.annotation.JsonFormat;
import de.ponton.xmlpipe.rest.jackson.TrimmedField;
import de.ponton.xmlpipe.rest.messagemonitor.MessageArchiveStatus;
import de.ponton.xmlpipe.rest.messagemonitor.MessageStatus;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.Date;
import org.springframework.validation.annotation.Validated;

@Validated
@Schema(description="Describes meta data of an exchanged message")
public class MessageDto {
    @NotNull
    @Schema(description="The technical ID of the message")
    private Long id;
    @NotNull
    @Schema(description="Determines if this message is inbound (true) or outbound (false)")
    private Boolean inbound;
    @NotNull
    @Schema(description="The status of the message")
    private MessageStatus status;
    @NotNull
    @Schema(description="Determines if this message is a test message (true) or not (false)")
    private Boolean test;
    @NotNull
    @Schema(description="Timestamp, which is set by an adapter (for outbound messages) or by the sender (for inbound messages)")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    private Date creationTime;
    @NotNull
    @Schema(description="Timestamp, which is set by the local messenger while message registration")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    private Date registrationTime;
    @Schema(description="The technical ID of the sending partner")
    @TrimmedField
    private String senderId;
    @Schema(description="The technical ID of the receiving partner")
    @TrimmedField
    private String receiverId;
    @NotNull
    @Schema(description="The message ID")
    @TrimmedField
    private String messageId;
    @NotNull
    @Schema(description="The conversation ID")
    @TrimmedField
    private String conversationId;
    @Schema(description="The sequence number of the message")
    private Long sequenceNumber;
    @Schema(description="The name of the schema set")
    @TrimmedField
    private String schemaSet;
    @Schema(description="The name of the message type")
    @TrimmedField
    private String messageType;
    @Schema(description="The used protocol while message transmission")
    @TrimmedField
    private String transmissionProtocol;
    @Schema(description="The used packager while message transmission")
    @TrimmedField
    private String packager;
    @Schema(description="The technical ID of the sending adapter")
    @TrimmedField
    private String adapterId;
    @Schema(description="Determines if a ACK received for the messages")
    private Boolean ackReceived;
    @Schema(description="The log info of the messages")
    @TrimmedField
    private String logInfo;
    @NotNull
    @Schema(description="The technical ID of the processing messenger instance")
    private Integer clusterNodeId;
    @NotNull
    @Schema(description="The archive status of the message")
    private MessageArchiveStatus archiveStatus;

    public Long getId() {
        return this.id;
    }

    public MessageDto setId(Long id) {
        this.id = id;
        return this;
    }

    public Boolean getInbound() {
        return this.inbound;
    }

    public MessageDto setInbound(Boolean inbound) {
        this.inbound = inbound;
        return this;
    }

    public MessageStatus getStatus() {
        return this.status;
    }

    public MessageDto setStatus(MessageStatus status) {
        this.status = status;
        return this;
    }

    public Boolean getTest() {
        return this.test;
    }

    public MessageDto setTest(Boolean test) {
        this.test = test;
        return this;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public MessageDto setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    public Date getRegistrationTime() {
        return this.registrationTime;
    }

    public MessageDto setRegistrationTime(Date registrationTime) {
        this.registrationTime = registrationTime;
        return this;
    }

    public String getSenderId() {
        return this.senderId;
    }

    public MessageDto setSenderId(String senderId) {
        this.senderId = senderId;
        return this;
    }

    public String getReceiverId() {
        return this.receiverId;
    }

    public MessageDto setReceiverId(String receiverId) {
        this.receiverId = receiverId;
        return this;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public MessageDto setMessageId(String messageId) {
        this.messageId = messageId;
        return this;
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public MessageDto setConversationId(String conversationId) {
        this.conversationId = conversationId;
        return this;
    }

    public Long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public MessageDto setSequenceNumber(Long sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
        return this;
    }

    public String getSchemaSet() {
        return this.schemaSet;
    }

    public MessageDto setSchemaSet(String schemaSet) {
        this.schemaSet = schemaSet;
        return this;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public MessageDto setMessageType(String messageType) {
        this.messageType = messageType;
        return this;
    }

    public String getTransmissionProtocol() {
        return this.transmissionProtocol;
    }

    public MessageDto setTransmissionProtocol(String transmissionProtocol) {
        this.transmissionProtocol = transmissionProtocol;
        return this;
    }

    public String getPackager() {
        return this.packager;
    }

    public MessageDto setPackager(String packager) {
        this.packager = packager;
        return this;
    }

    public String getAdapterId() {
        return this.adapterId;
    }

    public MessageDto setAdapterId(String adapterId) {
        this.adapterId = adapterId;
        return this;
    }

    public Boolean getAckReceived() {
        return this.ackReceived;
    }

    public MessageDto setAckReceived(Boolean ackReceived) {
        this.ackReceived = ackReceived;
        return this;
    }

    public String getLogInfo() {
        return this.logInfo;
    }

    public MessageDto setLogInfo(String logInfo) {
        this.logInfo = logInfo;
        return this;
    }

    public Integer getClusterNodeId() {
        return this.clusterNodeId;
    }

    public MessageDto setClusterNodeId(Integer clusterNodeId) {
        this.clusterNodeId = clusterNodeId;
        return this;
    }

    public MessageArchiveStatus getArchiveStatus() {
        return this.archiveStatus;
    }

    public MessageDto setArchiveStatus(MessageArchiveStatus archiveStatus) {
        this.archiveStatus = archiveStatus;
        return this;
    }
}

