/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.message;

import de.ponton.xmlpipe.rest.message.MessageArtifact;
import de.ponton.xmlpipe.rest.message.MessageController;
import de.pontonconsulting.xmlpipe.TempFileCreator;
import de.pontonconsulting.xmlpipe.message.Messages;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.archive.ArchiveProcessor;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.FileType;
import de.pontonconsulting.xmlpipe.messenger.database.MessageInfo;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.FileRef;
import de.pontonconsulting.xmlpipe.messenger.database.tables.FileRefDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class MessageService {
    private final Messages messages;
    private final MessageDAO messageDAO;
    private final FileRefDAO fileRefDAO;
    private final ArchiveProcessor archiveProcessor;
    private final TempFileCreator tempFileCreator;
    private static final Logger LOG = LogManager.getLogger((String)("Messenger." + MessageController.class.getName()));
    private static final Logger AUDIT = LogManager.getLogger((String)("Audit." + MessageController.class.getName()));

    public MessageService(Messages messages, MessageDAO messageDAO, FileRefDAO fileRefDAO, ArchiveProcessor archiveProcessor, TempFileCreator tempFileCreator) {
        this.messages = messages;
        this.messageDAO = messageDAO;
        this.fileRefDAO = fileRefDAO;
        this.archiveProcessor = archiveProcessor;
        this.tempFileCreator = tempFileCreator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void viewMessage(HttpServletResponse response, MessageArtifact messageArtifact, String user, long messageDataID) throws IOException, DbException {
        MessageInfo messageInfo = this.messageDAO.getMessageInfo(messageDataID);
        if (messageInfo == null) {
            throw new IllegalArgumentException("No message found for the given id " + messageDataID);
        }
        if (MessageArtifact.HTML_RENDERED_PAYLOAD == messageArtifact) {
            File archivedFile = this.tempFileCreator.createTempFile("archive", ".dat");
            try {
                try (OutputStream outputStream = Files.newOutputStream(archivedFile.toPath(), new OpenOption[0]);){
                    this.archiveProcessor.writeFileFromArchiveToOutputStream(messageInfo, messageArtifact, outputStream);
                }
                response.setContentType("text/html");
                this.setDownloadHeaders(response, messageDataID, "rendered.html");
                AUDIT.warn("User '{}' viewed HTML form of the message with messageId {} and id {}.", (Object)user, (Object)messageInfo.getMessageId(), (Object)messageInfo.getDatabaseId());
                ServletOutputStream out = response.getOutputStream();
                try {
                    this.messages.transform(null, messageInfo, archivedFile, (OutputStream)out);
                }
                catch (Exception e) {
                    response.setStatus(415);
                }
            }
            finally {
                this.tempFileCreator.deleteFile(archivedFile);
            }
        } else {
            this.setDownloadHeaders(response, messageDataID, this.archiveProcessor.getArchiveFileRef(messageInfo, messageArtifact, null).getFileName());
            this.setContentType(response, messageArtifact, messageInfo);
            this.archiveProcessor.writeFileFromArchiveToOutputStream(messageInfo, messageArtifact, (OutputStream)response.getOutputStream());
        }
        AUDIT.info("User '{}' viewed message artifact '{}'", (Object)user, (Object)messageArtifact);
    }

    private void setContentType(HttpServletResponse response, MessageArtifact messageArtifact, MessageInfo messageInfo) throws IOException {
        boolean hasXmlEnvelope = "EbXml20".equals(messageInfo.getPackagingId()) || "AS4".equals(messageInfo.getPackagingId());
        response.setContentType(switch (messageArtifact) {
            default -> throw new MatchException(null, null);
            case MessageArtifact.BACKEND_ENVELOPE -> "text/xml";
            case MessageArtifact.HTML_RENDERED_PAYLOAD -> "text/html";
            case MessageArtifact.RAW_PAYLOAD -> this.determineContentType(messageInfo);
            case MessageArtifact.PACKAGING_ENVELOPE -> hasXmlEnvelope ? "text/xml" : "text/plain";
        });
    }

    private String buildFileName(long messageDataID, String fileName) {
        return messageDataID + "_" + fileName;
    }

    private void setDownloadHeaders(HttpServletResponse response, long messageDataID, String filename) {
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"%s\"", this.buildFileName(messageDataID, filename)));
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
    }

    private String determineContentType(MessageInfo messageInfo) {
        try {
            Optional<String> mimeType = this.fileRefDAO.getArchiveFileRefs(messageInfo.getDatabaseId(), FileType.PAYLOAD).stream().map(FileRef::getMimeType).filter(Objects::nonNull).findFirst();
            if (mimeType.isPresent()) {
                return mimeType.get();
            }
            Optional<XpMessage> xpMessage = this.archiveProcessor.getXpMessageFromArchive(messageInfo);
            if (xpMessage.isPresent() && Objects.nonNull(xpMessage.get().getCurrentContentType())) {
                return xpMessage.get().getCurrentContentType();
            }
        }
        catch (Exception e) {
            LOG.error("Could not determine content type for message with id {}", (Object)messageInfo.getDatabaseId(), (Object)e);
        }
        return "text/xml";
    }
}

