/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.listener.http;

import de.ponton.xmlpipe.rest.listener.common.ListenerIpConnectionDto;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;

@Validated
@Schema(description="Holds the configuration of the HTTP listener.")
public class HttpListenerDto {
    @NotNull
    @Valid
    @Schema(description="The listener IP address and the port number is used to receive messages from communication partners.")
    private ListenerIpConnectionDto connection;
    @Schema(description="Set to 'true' to enable the HTTP listener, set to 'false' to disable it.")
    private boolean enabled;

    public ListenerIpConnectionDto getConnection() {
        return this.connection;
    }

    public HttpListenerDto setConnection(ListenerIpConnectionDto connection) {
        this.connection = connection;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public HttpListenerDto setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HttpListenerDto)) {
            return false;
        }
        HttpListenerDto that = (HttpListenerDto)o;
        return this.enabled == that.enabled && Objects.equals(this.connection, that.connection);
    }

    public int hashCode() {
        return Objects.hash(this.connection, this.enabled);
    }

    public String toString() {
        return "HttpListenerDto{connection=" + String.valueOf(this.connection) + ", enabled=" + this.enabled + "}";
    }
}

