/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.listener.ftp;

import de.ponton.xmlpipe.rest.listener.common.ListenerIpConnectionDto;
import de.ponton.xmlpipe.rest.listener.ftp.FtpDataConnectionDto;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;

@Validated
@Schema(description="Holds the configuration of the FTP listener.")
public class FtpListenerDto {
    @NotNull
    @Valid
    @Schema(description="The service connection configuration of the FTP listener.")
    private ListenerIpConnectionDto serviceConnection;
    @Schema(description="Set to 'true' to enable the FTP listener, set to 'false' to disable it.")
    private boolean enabled;
    @NotNull
    @Valid
    @Schema(description="The FTP data connection configuration.")
    private FtpDataConnectionDto dataConnection;

    public ListenerIpConnectionDto getServiceConnection() {
        return this.serviceConnection;
    }

    public FtpListenerDto setServiceConnection(ListenerIpConnectionDto serviceConnection) {
        this.serviceConnection = serviceConnection;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public FtpListenerDto setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public FtpDataConnectionDto getDataConnection() {
        return this.dataConnection;
    }

    public FtpListenerDto setDataConnection(FtpDataConnectionDto dataConnection) {
        this.dataConnection = dataConnection;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FtpListenerDto)) {
            return false;
        }
        FtpListenerDto that = (FtpListenerDto)o;
        return this.enabled == that.enabled && Objects.equals(this.serviceConnection, that.serviceConnection) && Objects.equals(this.dataConnection, that.dataConnection);
    }

    public int hashCode() {
        return Objects.hash(this.serviceConnection, this.enabled, this.dataConnection);
    }

    public String toString() {
        return "FtpListenerDto{serviceConnection=" + String.valueOf(this.serviceConnection) + ", enabled=" + this.enabled + ", dataConnection=" + String.valueOf(this.dataConnection) + "}";
    }
}

