/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.listener;

import de.ponton.securelistener.config.ListenerProperties;
import de.ponton.securelistener.ftp.FtpExchangeUser;
import de.ponton.securelistener.ftp.FtpExchangeUserProperties;
import de.ponton.xmlpipe.rest.DtoFactoryException;
import de.ponton.xmlpipe.rest.IDtoFactory;
import de.ponton.xmlpipe.rest.listener.ListenerConfigurationDto;
import de.ponton.xmlpipe.rest.listener.common.ListenerIpConnectionDto;
import de.ponton.xmlpipe.rest.listener.ftp.FtpDataConnectionDto;
import de.ponton.xmlpipe.rest.listener.ftp.FtpListenerDto;
import de.ponton.xmlpipe.rest.listener.ftp.FtpLoginDto;
import de.ponton.xmlpipe.rest.listener.http.HttpListenerDto;
import de.ponton.xmlpipe.rest.listener.http.HttpsListenerDto;
import de.ponton.xmlpipe.rest.listener.http.WebListenerDto;
import de.ponton.xmlpipe.rest.listener.proxy.ListenerProxyDto;
import de.ponton.xmlpipe.rest.settings.common.authentication.AuthenticationDto;
import de.pontonconsulting.xmlpipe.config.ListenerConfig;
import de.pontonconsulting.xmlpipe.config.listener.ListenerConfigException;
import de.pontonconsulting.xmlpipe.config.model.listener.XpListenerConfigurationDto;
import java.util.Optional;
import java.util.stream.Collectors;
import org.modelmapper.ModelMapper;
import org.springframework.stereotype.Component;

@Component
public class ListenerConfigurationDtoFactory
implements IDtoFactory<ListenerConfigurationDto, XpListenerConfigurationDto> {
    private final ListenerConfig listenerConfig;
    private final ModelMapper modelMapper;

    public ListenerConfigurationDtoFactory(ListenerConfig listenerConfig, ModelMapper modelMapper) {
        this.listenerConfig = listenerConfig;
        this.modelMapper = modelMapper;
    }

    @Override
    public ListenerConfigurationDto create(XpListenerConfigurationDto valueObject) {
        ListenerProperties listenerProperties = valueObject.getListenerProperties();
        FtpExchangeUserProperties ftpExchangeUserProperties = valueObject.getFtpExchangeUserProperties();
        if (listenerProperties == null || ftpExchangeUserProperties == null) {
            throw new DtoFactoryException("Can't create ListenerConfiguration because the input is invalid.");
        }
        return new ListenerConfigurationDto().setListenerProxy(new ListenerProxyDto().setConnection(new ListenerIpConnectionDto().setIp(listenerProperties.getProxyAddress()).setPort(listenerProperties.getProxyPort())).setEnabled(listenerProperties.isProxyEnabled())).setWebListener(new WebListenerDto().setHttpListener(new HttpListenerDto().setConnection(new ListenerIpConnectionDto().setIp(listenerProperties.getSecureListenerHttpAddress()).setPort(listenerProperties.getSecureListenerHttpPort())).setEnabled(listenerProperties.isSecureListenerHttpEnabled())).setHttpsListener(new HttpsListenerDto().setConnection(new ListenerIpConnectionDto().setIp(listenerProperties.getSecureListenerHttpsAddress()).setPort(listenerProperties.getSecureListenerHttpsPort())).setDoClientCertificateCheck(listenerProperties.isSenderCertificateCheck()).setDoClientCertificateAuth(listenerProperties.isSenderCertificateAuth()).setSniEnabled(listenerProperties.isSecureListenerSniEnabled()).setEnabled(listenerProperties.isSecureListenerHttpsEnabled()).setUsePartnerCertificate(listenerProperties.getSynchronizePartnerCertificates())).setMaxDataSize(listenerProperties.getForwardMaxDatasize())).setFtpListener(new FtpListenerDto().setServiceConnection(new ListenerIpConnectionDto().setIp(listenerProperties.getFtpListenerAddress()).setPort(listenerProperties.getFtpListenerPort())).setEnabled(listenerProperties.isFtpListenerEnabled()).setDataConnection(new FtpDataConnectionDto().setIp(listenerProperties.getFtpDataConnectionAddress()).setFromPort(listenerProperties.getFtpDataConnectionFromPort()).setToPort(listenerProperties.getFtpDataConnectionToPort()).setLogins(ftpExchangeUserProperties.getFtpExchangeUsers().stream().map(ftpExchangeUser -> new FtpLoginDto().setAuthentication(new AuthenticationDto().setUsername(ftpExchangeUser.getUserName()).setPassword(Optional.ofNullable(ftpExchangeUser.getPassword()).orElse(ftpExchangeUser.getEncryptedPassword()))).setPartnerId(ftpExchangeUser.getPartnerLocalId())).collect(Collectors.toList()))));
    }

    @Override
    public XpListenerConfigurationDto parse(ListenerConfigurationDto valueObject) {
        FtpExchangeUserProperties ftpExchangeUserProperties;
        ListenerProperties listenerProperties;
        try {
            listenerProperties = (ListenerProperties)this.modelMapper.map((Object)this.listenerConfig.getListenerConfiguration().getListenerProperties(), ListenerProperties.class);
            ftpExchangeUserProperties = (FtpExchangeUserProperties)this.modelMapper.map((Object)this.listenerConfig.getListenerConfiguration().getFtpExchangeUserProperties(), FtpExchangeUserProperties.class);
        }
        catch (ListenerConfigException e) {
            throw new DtoFactoryException(e);
        }
        if (valueObject.getListenerProxy() != null) {
            listenerProperties.setProxyEnabled(valueObject.getListenerProxy().isEnabled());
            listenerProperties.setProxyAddress(valueObject.getListenerProxy().getConnection().getIp());
            listenerProperties.setProxyPort(valueObject.getListenerProxy().getConnection().getPort().intValue());
        } else {
            listenerProperties.setProxyEnabled(false);
        }
        if (valueObject.getWebListener() != null) {
            if (valueObject.getWebListener().getHttpListener() != null) {
                listenerProperties.setSecureListenerHttpEnabled(valueObject.getWebListener().getHttpListener().isEnabled());
                listenerProperties.setSecureListenerHttpAddress(valueObject.getWebListener().getHttpListener().getConnection().getIp());
                listenerProperties.setSecureListenerHttpPort(valueObject.getWebListener().getHttpListener().getConnection().getPort().intValue());
            } else {
                listenerProperties.setSecureListenerHttpEnabled(false);
            }
            if (valueObject.getWebListener().getHttpsListener() != null) {
                listenerProperties.setSecureListenerHttpsEnabled(valueObject.getWebListener().getHttpsListener().isEnabled());
                listenerProperties.setSecureListenerSniEnabled(valueObject.getWebListener().getHttpsListener().isSniEnabled());
                listenerProperties.setSecureListenerHttpsAddress(valueObject.getWebListener().getHttpsListener().getConnection().getIp());
                listenerProperties.setSecureListenerHttpsPort(valueObject.getWebListener().getHttpsListener().getConnection().getPort().intValue());
                listenerProperties.setSenderCertificateCheck(valueObject.getWebListener().getHttpsListener().isDoClientCertificateCheck());
                listenerProperties.setSenderCertificateAuth(valueObject.getWebListener().getHttpsListener().isDoClientCertificateAuth());
                listenerProperties.setSynchronizePartnerCertificates(valueObject.getWebListener().getHttpsListener().isUsePartnerCertificate());
            } else {
                listenerProperties.setSecureListenerHttpsEnabled(false);
            }
            listenerProperties.setForwardMaxDatasize(valueObject.getWebListener().getMaxDataSize().longValue());
        }
        if (valueObject.getFtpListener() != null) {
            listenerProperties.setFtpListenerEnabled(valueObject.getFtpListener().isEnabled());
            listenerProperties.setFtpListenerAddress(valueObject.getFtpListener().getServiceConnection().getIp());
            listenerProperties.setFtpListenerPort(valueObject.getFtpListener().getServiceConnection().getPort().intValue());
            listenerProperties.setFtpDataConnectionAddress(valueObject.getFtpListener().getDataConnection().getIp());
            listenerProperties.setFtpDataConnectionPorts(valueObject.getFtpListener().getDataConnection().getFromPort() + "-" + valueObject.getFtpListener().getDataConnection().getToPort());
            ftpExchangeUserProperties = new FtpExchangeUserProperties(valueObject.getFtpListener().getDataConnection().getLogins().stream().map(ftpLoginDto -> {
                FtpExchangeUser ftpExchangeUser = new FtpExchangeUser();
                ftpExchangeUser.setUserName(ftpLoginDto.getAuthentication().getUsername());
                ftpExchangeUser.setPassword(ftpLoginDto.getAuthentication().getPassword());
                ftpExchangeUser.setPartnerLocalId(ftpLoginDto.getPartnerId());
                return ftpExchangeUser;
            }).collect(Collectors.toList()));
        } else {
            listenerProperties.setFtpListenerEnabled(false);
        }
        return new XpListenerConfigurationDto().setListenerProperties(listenerProperties).setFtpExchangeUserProperties(ftpExchangeUserProperties);
    }
}

