/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.jwt;

import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.security.Keys;
import io.jsonwebtoken.security.WeakKeyException;
import jakarta.servlet.http.HttpServletRequest;
import java.security.Key;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Component;

@Component
public class JwtTokenUtil {
    private final Logger log = LogManager.getLogger((String)("Messenger." + this.getClass().getSimpleName()));
    public final long jwtTokenValidity;
    private static final String REMOTE_IP = "remoteIP";
    private static final String FORWARDED_FOR = "forwardedFor";
    private static final String EMPTY_STRING = "";
    private final boolean ignoreIpAddress;
    private final String secret;
    private Key key;

    public JwtTokenUtil(MessengerConfig messengerConfig) {
        this.secret = messengerConfig.getJwtSecret();
        this.jwtTokenValidity = TimeUnit.MINUTES.toMillis(messengerConfig.getJwtExpiration());
        this.ignoreIpAddress = messengerConfig.isJwtIgnoreIpAddress();
        try {
            this.key = Keys.hmacShaKeyFor((byte[])Base64.getEncoder().encode(this.secret.getBytes()));
        }
        catch (WeakKeyException e) {
            this.log.warn("JWT Secret is too short, using a secure one until its fixed. Error: {}", (Object)e.getMessage());
            this.key = Keys.secretKeyFor((SignatureAlgorithm)SignatureAlgorithm.HS512);
        }
    }

    public String getUsernameFromToken(String token, String remoteIp, String forwardedFor) {
        JwtParser jwtParser = Jwts.parser().setSigningKey(this.key).build();
        if (!this.ignoreIpAddress) {
            jwtParser = Jwts.parser().setSigningKey(this.key).require(REMOTE_IP, (Object)remoteIp).require(FORWARDED_FOR, (Object)Objects.requireNonNullElse(forwardedFor, EMPTY_STRING)).build();
        }
        return ((Claims)jwtParser.parseClaimsJws((CharSequence)token).getBody()).getSubject();
    }

    public OffsetDateTime getTokenExpirationDate(String token) {
        JwtParser jwtParser = Jwts.parser().setSigningKey(this.key).build();
        return OffsetDateTime.ofInstant(((Claims)jwtParser.parseClaimsJws((CharSequence)token).getBody()).getExpiration().toInstant(), ZoneOffset.UTC);
    }

    public String generateToken(UserDetails userDetails, HttpServletRequest request, Date now) {
        String forwardedFor = Objects.requireNonNullElse(request.getHeader("X-forwarded-for"), EMPTY_STRING);
        HashMap<String, String> claims = new HashMap<String, String>();
        claims.put(REMOTE_IP, request.getRemoteAddr());
        claims.put(FORWARDED_FOR, forwardedFor);
        claims.put("SALT", UUID.randomUUID().toString());
        String subject = userDetails.getUsername();
        return ((JwtBuilder)((JwtBuilder)((JwtBuilder)((JwtBuilder)Jwts.builder().setId(UUID.randomUUID().toString())).setClaims(claims).setSubject(subject)).setIssuedAt(now)).setExpiration(new Date(now.getTime() + this.jwtTokenValidity))).signWith(this.key, SignatureAlgorithm.HS512).compact();
    }
}

