/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.httpadapter;

import de.ponton.xmlpipe.rest.exception.ResourceNotFoundException;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.HttpAdapterInfo;
import de.pontonconsulting.xmlpipe.messenger.database.tables.HttpAdapterInfoDAO;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.validation.Valid;
import java.security.Principal;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/httpAdapterConfig"})
@Validated
public class HttpAdapterConfigController {
    private final Logger log = LogManager.getLogger((String)("Messenger." + this.getClass().getSimpleName()));
    public static final String DOCUMENTATION_TAG_HTTP_ADAPTER_CONFIG = "Http Adapter Config";
    private final HttpAdapterInfoDAO httpAdapterInfoDao;

    public HttpAdapterConfigController(HttpAdapterInfoDAO httpAdapterInfoDao) {
        this.httpAdapterInfoDao = httpAdapterInfoDao;
    }

    @GetMapping
    @Secured(value={"HTTP_ADAPTER_CONFIG_GET"})
    @Operation(summary="Get a list of the configurations for all http adapters", description="permission:HTTP_ADAPTER_CONFIG_GET<br><br>Returns a list of configurations for all http adapters.", tags={"Http Adapter Config"})
    public ResponseEntity<List<HttpAdapterInfo>> getAllHttpAdapters() {
        return ResponseEntity.ok(this.httpAdapterInfoDao.getAllHttpAdapters());
    }

    @GetMapping(value={"/{adapterId}"})
    @Secured(value={"HTTP_ADAPTER_CONFIG_GET"})
    @Operation(summary="Get a http adapter configuration", description="permission:HTTP_ADAPTER_CONFIG_GET<br><br>Returns the configuration of a http adapter.", tags={"Http Adapter Config"})
    public ResponseEntity<HttpAdapterInfo> getHttpAdapter(@PathVariable String adapterId) {
        return ResponseEntity.ok((Object)this.httpAdapterInfoDao.getHttpAdapter(adapterId));
    }

    @PutMapping
    @Secured(value={"HTTP_ADAPTER_CONFIG_PUT"})
    @Operation(summary="Save a new or updated http adapter", description="permission:HTTP_ADAPTER_CONFIG_PUT<br><br>Create a new http adapter or change the configuration of an existing http adapter", tags={"Http Adapter Config"})
    public ResponseEntity<Void> saveHttpAdapter(@Valid @RequestBody HttpAdapterInfo httpAdapterInfo, Principal principal) {
        boolean isNewHttpAdapter = this.httpAdapterInfoDao.storeHttpAdapter(httpAdapterInfo, principal.getName());
        if (isNewHttpAdapter) {
            this.log.info("Created new Http Adapter with id {}", (Object)httpAdapterInfo.getAdapterId());
        } else {
            this.log.info("Updated Http Adapter with id {}", (Object)httpAdapterInfo.getAdapterId());
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NO_CONTENT).build();
    }

    @DeleteMapping(value={"/{adapterId}"})
    @Secured(value={"HTTP_ADAPTER_CONFIG_DELETE"})
    @Operation(summary="Delete an existing http adapter", description="permission:HTTP_ADAPTER_CONFIG_DELETE<br><br>Delete an existing http adapter or return http not found error when there is no http adapter with the given id", tags={"Http Adapter Config"})
    public ResponseEntity<Void> deleteHttpAdapter(@PathVariable String adapterId) {
        if (this.httpAdapterInfoDao.httpAdapterExists(adapterId)) {
            this.httpAdapterInfoDao.deleteHttpAdapter(adapterId);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NO_CONTENT).build();
        }
        throw new ResourceNotFoundException(String.format("Http adapter with adapter id %s not found", adapterId));
    }
}

