/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.help;

import de.ponton.xmlpipe.rest.help.HelpURLsDto;
import de.pontonconsulting.xmlpipe.Constants;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import io.swagger.v3.oas.annotations.Operation;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/help"})
@Validated
public class MessengerHelpController {
    public static final String DOCUMENTATION_TAG = "Help";
    private final MessengerConfig messengerConfig;

    public MessengerHelpController(MessengerConfig messengerConfig) {
        this.messengerConfig = messengerConfig;
    }

    @GetMapping(value={"/urls"})
    @Operation(summary="Get product related URLs", tags={"Help"})
    public ResponseEntity<HelpURLsDto> getHelpURLs() {
        HelpURLsDto helpURL = new HelpURLsDto().setMessengerDocumentation(this.messengerConfig.getProperty("ponton.messenger.help.url.messenger_documentation", this.buildUrl("https://www.ponton.de/downloads/xp/%s/documents/MessengerDocumentation%s.pdf"))).setReleaseNotes(this.messengerConfig.getProperty("ponton.messenger.help.url.release_notes", this.buildUrl("https://www.ponton.de/downloads/xp/%s/documents/ReleaseNotes%s.pdf"))).setSystemRequirements(this.messengerConfig.getProperty("ponton.messenger.help.url.system_requirements", this.buildUrl("https://www.ponton.de/downloads/xp/%s/documents/SystemRequirements%s.pdf"))).setBackendIntegrationGuide(this.messengerConfig.getProperty("ponton.messenger.help.url.backend_integration_guide", this.buildUrl("https://www.ponton.de/downloads/xp/%s/documents/BackendIntegrationGuide%s.pdf"))).setAdapterProgrammingGuide(this.messengerConfig.getProperty("ponton.messenger.help.url.adapter_programming_guide", this.buildUrl("https://www.ponton.de/downloads/xp/%s/documents/Adapter2ProgrammingGuide%s.pdf"))).setSupport(this.messengerConfig.getProperty("ponton.messenger.help.url.support", "https://support.ponton.de/")).setProductPage(this.messengerConfig.getProperty("ponton.messenger.help.url.product_page", "https://www.ponton.de/products/xpmessenger/"));
        return ResponseEntity.ok((Object)helpURL);
    }

    private String buildUrl(String url) {
        String xpVersion = Constants.getXP_VERSION().replaceAll("\\(.*\\)", "").replaceAll("_.*", "").replaceAll("-.*", "").trim();
        return url.formatted(xpVersion, xpVersion.replace('.', '_'));
    }
}

