/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpp.certificate;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.ponton.xmlpipe.rest.cpp.certificate.validation.NotExpiredCertificate;
import de.ponton.xmlpipe.rest.jackson.TrimmedField;
import de.ponton.xmlpipe.rest.validation.NullOrNotBlank;
import io.swagger.v3.oas.annotations.media.Schema;
import org.springframework.validation.annotation.Validated;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@Schema(description="Sets the Certificate id for packaging and processing")
@Validated
public class DefaultCertificateDto {
    @JsonIgnore
    @TrimmedField
    private String partnerLocalId;
    @Schema(description="Default Certificate id")
    @JsonProperty(value="default")
    @NullOrNotBlank
    @NotExpiredCertificate
    @TrimmedField
    private String defaultCertificate;
    @Schema(description="Overrides default Certificate id for ebXML packaging type")
    @NullOrNotBlank
    @NotExpiredCertificate
    @TrimmedField
    private String ebXml;
    @Schema(description="Overrides default Certificate id for AS1 packaging type")
    @NullOrNotBlank
    @NotExpiredCertificate
    @TrimmedField
    private String as1;
    @Schema(description="Overrides default Certificate id for AS2 packaging type")
    @NullOrNotBlank
    @NotExpiredCertificate
    @TrimmedField
    private String as2;
    @Schema(description="Overrides default Certificate id for AS3 packaging type")
    @NullOrNotBlank
    @NotExpiredCertificate
    @TrimmedField
    private String as3;
    @Schema(description="Overrides default Certificate id for AS4 packaging type")
    @NullOrNotBlank
    @NotExpiredCertificate
    @TrimmedField
    private String as4;
    @Schema(description="Overrides default Certificate id for processing")
    @NullOrNotBlank
    @NotExpiredCertificate
    @TrimmedField
    private String processing;

    public String getDefaultCertificate() {
        return this.defaultCertificate;
    }

    public DefaultCertificateDto setDefaultCertificate(String defaultCertificate) {
        this.defaultCertificate = defaultCertificate;
        return this;
    }

    public String getEbXml() {
        return this.ebXml;
    }

    public DefaultCertificateDto setEbXml(String ebXml) {
        this.ebXml = ebXml;
        return this;
    }

    public String getAs1() {
        return this.as1;
    }

    public DefaultCertificateDto setAs1(String as1) {
        this.as1 = as1;
        return this;
    }

    public String getAs2() {
        return this.as2;
    }

    public DefaultCertificateDto setAs2(String as2) {
        this.as2 = as2;
        return this;
    }

    public String getAs3() {
        return this.as3;
    }

    public DefaultCertificateDto setAs3(String as3) {
        this.as3 = as3;
        return this;
    }

    public String getAs4() {
        return this.as4;
    }

    public DefaultCertificateDto setAs4(String as4) {
        this.as4 = as4;
        return this;
    }

    public String getProcessing() {
        return this.processing;
    }

    public DefaultCertificateDto setProcessing(String processing) {
        this.processing = processing;
        return this;
    }

    public String getPartnerLocalId() {
        return this.partnerLocalId;
    }

    public DefaultCertificateDto setPartnerLocalId(String partnerLocalId) {
        this.partnerLocalId = partnerLocalId;
        return this;
    }
}

