/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpp.certificate;

import de.ponton.xmlpipe.rest.jackson.ObfuscatedField;
import de.ponton.xmlpipe.rest.jackson.TrimmedField;
import de.ponton.xmlpipe.rest.validation.PasswordStrengthConstraint;
import de.pontonconsulting.xmlpipe.admintool.messenger.ssl.certificate.KeyPairAlgorithm;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Email;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Pattern;
import org.springframework.validation.annotation.Validated;

@Validated
@Schema(description="A Certificate Signing Request (CSR) or Certification Request is a digital request to create a digital certificate from a public key using a digital signature. For more information see explanation on Wikipedia: https://en.wikipedia.org/wiki/Certificate_signing_request")
public class CreateCertificateRequestDto {
    @NotBlank
    @Schema(description="The common name. This is the fully qualified domain name that you wish to secure.")
    @TrimmedField
    private String cn;
    @Schema(description="The organizational unit. Internal organization department/division name.")
    @TrimmedField
    private String ou;
    @NotBlank
    @Schema(description="The organization name. Usually the legal name of a company or entity and should include any suffixes such as Ltd., Inc., or Corp.")
    @TrimmedField
    private String o;
    @Schema(description="The locality. Town, city, village, etc. name.")
    @TrimmedField
    private String l;
    @Schema(description="Province, region, county or state. This should not be abbreviated (e.g. West Sussex, Normandy, New Jersey).")
    @TrimmedField
    private String st;
    @NotBlank
    @Schema(description="The country. The two-letter ISO code for the country where your organization is located")
    @TrimmedField
    @Pattern(regexp="[a-zA-Z]{2}")
    private @NotBlank @Pattern(regexp="[a-zA-Z]{2}") String c;
    @NotBlank
    @Email
    @Schema(description="The organization contact, usually of the certificate administrator or IT department")
    @TrimmedField
    private String email;
    @Schema(description="The fax number of the organization.")
    @TrimmedField
    private String fax;
    @Schema(description="The phone number of the organization.")
    @TrimmedField
    private String phone;
    @Schema(description="The common name of the certificate")
    @NotBlank
    @ObfuscatedField
    @PasswordStrengthConstraint
    private String password;
    @Schema(description="This flag defines if non-standard data is included in the certificate request. Should only be activated when the CSR will be signed by PONTON CA")
    private boolean extensions;
    @Schema(description="The KeyPairAlgorithm for the certificate")
    private KeyPairAlgorithm keyPair = KeyPairAlgorithm.RSA_2048;

    public boolean getExtensions() {
        return this.extensions;
    }

    public CreateCertificateRequestDto setExtensions(boolean extensions) {
        this.extensions = extensions;
        return this;
    }

    public KeyPairAlgorithm getKeyPair() {
        return this.keyPair;
    }

    public CreateCertificateRequestDto setKeyPair(KeyPairAlgorithm keyPair) {
        this.keyPair = keyPair;
        return this;
    }

    public String getCn() {
        return this.cn;
    }

    public CreateCertificateRequestDto setCn(String cn) {
        this.cn = cn;
        return this;
    }

    public String getOu() {
        return this.ou;
    }

    public CreateCertificateRequestDto setOu(String ou) {
        this.ou = ou;
        return this;
    }

    public String getO() {
        return this.o;
    }

    public CreateCertificateRequestDto setO(String o) {
        this.o = o;
        return this;
    }

    public String getL() {
        return this.l;
    }

    public CreateCertificateRequestDto setL(String l) {
        this.l = l;
        return this;
    }

    public String getSt() {
        return this.st;
    }

    public CreateCertificateRequestDto setSt(String st) {
        this.st = st;
        return this;
    }

    public String getC() {
        return this.c;
    }

    public CreateCertificateRequestDto setC(String c) {
        this.c = c;
        return this;
    }

    public String getEmail() {
        return this.email;
    }

    public CreateCertificateRequestDto setEmail(String email) {
        this.email = email;
        return this;
    }

    public String getFax() {
        return this.fax;
    }

    public CreateCertificateRequestDto setFax(String fax) {
        this.fax = fax;
        return this;
    }

    public String getPhone() {
        return this.phone;
    }

    public CreateCertificateRequestDto setPhone(String phone) {
        this.phone = phone;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public CreateCertificateRequestDto setPassword(String password) {
        this.password = password;
        return this;
    }
}

