/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpp.certificate;

import de.ponton.xmlpipe.rest.jackson.ObfuscatedField;
import de.ponton.xmlpipe.rest.jackson.TrimmedField;
import de.ponton.xmlpipe.rest.validation.PasswordStrengthConstraint;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Email;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import org.springframework.validation.annotation.Validated;

@Validated
@Schema(description="A Certificate Signing Request (CSR) or Certification Request is a digital request to create a digital certificate from a public key using a digital signature. For more information see explanation on Wikipedia: https://en.wikipedia.org/wiki/Certificate_signing_request")
public class CreateBDEWCertificateRequestDto {
    @NotBlank
    @Schema(description="The name of the organization, ")
    @TrimmedField
    @Pattern(regexp="[0-9a-zA-Z\\-]{1,48}")
    private @NotBlank @Pattern(regexp="[0-9a-zA-Z\\-]{1,48}") String org;
    @Schema(description="The CN extension, ")
    @TrimmedField
    @Pattern(regexp="[0-9a-zA-Z\\-]{0,10}")
    private @Pattern(regexp="[0-9a-zA-Z\\-]{0,10}") String suffix;
    @NotNull
    @Schema(description="The AS4 communication URL")
    @Pattern(regexp="https://[a-zA-Z0-9\\-.]+(:\\d{1,5})?([/\\w.\\-%#?]*)")
    private @NotNull @Pattern(regexp="https://[a-zA-Z0-9\\-.]+(:\\d{1,5})?([/\\w.\\-%#?]*)") String url;
    @Schema(description="Market Partner ID")
    @TrimmedField
    private String ou;
    @Schema(description="Street")
    @TrimmedField
    private String street;
    @Schema(description="Postal Code")
    @TrimmedField
    private String postalCode;
    @Schema(description="The locality. Town, city, village, etc. name.")
    @TrimmedField
    private String l;
    @Schema(description="Province, region, county or state. This should not be abbreviated (e.g. West Sussex, Normandy, New Jersey).")
    @TrimmedField
    private String st;
    @NotBlank
    @Schema(description="The country. The two-letter ISO code for the country where your organization is located")
    @Pattern(regexp="[a-zA-Z]{2}")
    @TrimmedField
    private @NotBlank @Pattern(regexp="[a-zA-Z]{2}") String c;
    @NotBlank
    @Email
    @Schema(description="The organization contact, usually of the certificate administrator or IT department")
    @TrimmedField
    private String email;
    @Schema(description="The common name of the certificate")
    @NotBlank
    @ObfuscatedField
    @PasswordStrengthConstraint
    private String password;

    public String getOu() {
        return this.ou;
    }

    public CreateBDEWCertificateRequestDto setOu(String ou) {
        this.ou = ou;
        return this;
    }

    public String getL() {
        return this.l;
    }

    public CreateBDEWCertificateRequestDto setL(String l) {
        this.l = l;
        return this;
    }

    public String getSt() {
        return this.st;
    }

    public CreateBDEWCertificateRequestDto setSt(String st) {
        this.st = st;
        return this;
    }

    public String getC() {
        return this.c;
    }

    public CreateBDEWCertificateRequestDto setC(String c) {
        this.c = c;
        return this;
    }

    public String getEmail() {
        return this.email;
    }

    public CreateBDEWCertificateRequestDto setEmail(String email) {
        this.email = email;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public CreateBDEWCertificateRequestDto setPassword(String password) {
        this.password = password;
        return this;
    }

    public String getOrg() {
        return this.org;
    }

    public CreateBDEWCertificateRequestDto setOrg(String org) {
        this.org = org;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public CreateBDEWCertificateRequestDto setUrl(String url) {
        this.url = url;
        return this;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public CreateBDEWCertificateRequestDto setSuffix(String suffix) {
        this.suffix = suffix;
        return this;
    }

    public String getStreet() {
        return this.street;
    }

    public CreateBDEWCertificateRequestDto setStreet(String street) {
        this.street = street;
        return this;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public CreateBDEWCertificateRequestDto setPostalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }
}

