/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpp.certificate;

import de.ponton.xmlpipe.rest.certificate.CertificateDto;
import de.ponton.xmlpipe.rest.cpp.certificate.CertificateCaService;
import de.ponton.xmlpipe.rest.exception.ExceptionDto;
import de.ponton.xmlpipe.rest.exception.ExceptionDtoFactory;
import de.ponton.xmlpipe.rest.exception.ResourceNotFoundException;
import de.pontonconsulting.xmlpipe.admintool.InstallCertException;
import de.pontonconsulting.xmlpipe.security.bsi.SmartMeterPkiService;
import io.swagger.v3.oas.annotations.Operation;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ca"})
@Validated
public class CertificateCaController {
    public static final String DOCUMENTATION_TAG_CA = "Certificate Authority";
    private final Logger log = LogManager.getLogger((String)("Messenger." + this.getClass().getSimpleName()));
    private final CertificateCaService certificateCaService;
    private final SmartMeterPkiService smartMeterPkiService;
    private final ExceptionDtoFactory exceptionDtoFactory;

    public CertificateCaController(CertificateCaService certificateCaService, SmartMeterPkiService smartMeterPkiService, ExceptionDtoFactory exceptionDtoFactory) {
        this.certificateCaService = certificateCaService;
        this.smartMeterPkiService = smartMeterPkiService;
        this.exceptionDtoFactory = exceptionDtoFactory;
    }

    @GetMapping(value={"/subCANames"})
    @Secured(value={"CA_GET"})
    @Operation(summary="Get all Sub-CA names.", description="permission:CA_GET", tags={"Certificate Authority"})
    public ResponseEntity<SortedSet<String>> getAllSubCANames() {
        return ResponseEntity.ok(this.smartMeterPkiService.getAllServerNames());
    }

    @GetMapping
    @Secured(value={"CA_GET"})
    @Operation(summary="Get all Certificate Authorities", description="permission:CA_GET", tags={"Certificate Authority"})
    public ResponseEntity<List<CertificateDto>> getAllCaCertificates() throws KeyStoreException {
        return ResponseEntity.ok(this.certificateCaService.getAllCaCertificates());
    }

    @GetMapping(value={"/{id}"})
    @Operation(summary="Get Certificate Authority for id", description="permission:CA_GET", tags={"Certificate Authority"})
    @Secured(value={"CA_GET"})
    public ResponseEntity<CertificateDto> getCertificateForId(@PathVariable String id) throws KeyStoreException {
        Optional<CertificateDto> certificate = this.certificateCaService.getCertificate(id);
        return ResponseEntity.ok((Object)certificate.orElseThrow(() -> {
            throw new ResourceNotFoundException(String.format("CA does not exist. [id=%s]", id));
        }));
    }

    @PostMapping
    @Operation(summary="Import Certificate Authority", description="permission:CA_POST<br><br>Import the passed Certificate Authority if a CA does not already exist for the same issuer. Otherwise the already existing CA has to be deleted before", tags={"Certificate Authority"})
    @Secured(value={"CA_POST"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity<String> importCaCertificate(@RequestBody String certificate) throws InstallCertException, GeneralSecurityException {
        String id = this.certificateCaService.importCaCertificate(certificate);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)id);
    }

    @DeleteMapping(value={"/{id}"})
    @Secured(value={"CA_DELETE"})
    @Operation(summary="Delete a Certificate Authority", description="permission:CA_DELETE<br><br>Delete a Certificate Authority identified by the passed id", tags={"Certificate Authority"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public ResponseEntity<Void> deleteCaCertificate(@PathVariable String id) throws KeyStoreException {
        this.certificateCaService.deleteCaCertificate(id);
        return ResponseEntity.noContent().build();
    }

    @ExceptionHandler(value={KeyStoreException.class, InstallCertException.class, GeneralSecurityException.class})
    public ResponseEntity<ExceptionDto> handleBadRequest(Exception e) {
        this.log.error("Could not handle ca certificate data. Error: {}", (Object)e.getMessage());
        return new ResponseEntity((Object)this.exceptionDtoFactory.create(e), (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={ResourceNotFoundException.class})
    public ResponseEntity<ExceptionDto> handleNotFound(Exception e) {
        this.log.error("CA certificate data not found. Error: {}", (Object)e.getMessage());
        return new ResponseEntity((Object)this.exceptionDtoFactory.create(e), (HttpStatusCode)HttpStatus.NOT_FOUND);
    }
}

