/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpp;

import de.ponton.xmlpipe.rest.cpp.identification.PartyIdDto;
import de.ponton.xmlpipe.rest.cpp.maintenance.MaintenancePeriodDto;
import de.ponton.xmlpipe.rest.cpp.transport.TransportDto;
import de.ponton.xmlpipe.rest.cpp.validation.MessageTypeConstraint;
import de.ponton.xmlpipe.rest.jackson.TrimmedField;
import de.ponton.xmlpipe.rest.validation.Immutable;
import de.ponton.xmlpipe.rest.validation.NullOrFalse;
import de.ponton.xmlpipe.rest.validation.ValidationGroup;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Null;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.validator.constraints.UniqueElements;
import org.springframework.validation.annotation.Validated;

@Validated
@Schema(description="Describes a Partner, i.e. a participant with whom messages are to be exchanged (sent and/or received).", name="Partner")
public class PartnerDto {
    @Schema(description="The id of the partner")
    @Null(groups={ValidationGroup.Create.class})
    @NotBlank.List(value={@NotBlank(groups={ValidationGroup.Read.class}), @NotBlank(groups={ValidationGroup.Update.class})})
    @Size(max=100)
    @Immutable
    @TrimmedField
    private @Null(groups={ValidationGroup.Create.class}) @NotBlank.List(value={@NotBlank(groups={ValidationGroup.Read.class}), @NotBlank(groups={ValidationGroup.Update.class})}) @Size(max=100) String id;
    @NotNull
    @Schema(description="Determines if this partner is a remote partner (true) or a local partner (false)")
    @Immutable
    private Boolean remote;
    @NullOrFalse(groups={ValidationGroup.Create.class})
    @Schema(description="Determines if this partner was imported from a partner registry")
    private Boolean imported;
    @NotBlank
    @Size(max=100)
    @Schema(description="The display name of the partner")
    @TrimmedField
    private @NotBlank @Size(max=100) String displayName;
    @NotBlank
    @Size(max=100)
    @Schema(description="The backend id of the partner")
    @TrimmedField
    private @NotBlank @Size(max=100) String backendId;
    @NotBlank
    @Size(max=100)
    @Schema(description="The default packager of the partner")
    @TrimmedField
    private @NotBlank @Size(max=100) String defaultPackager;
    @NotNull
    @Schema(description="Determines if this partner is disabled (true) or not (false)")
    private Boolean disabled;
    @Size(max=100)
    @Schema(description="The name of the contact person of the partner")
    @TrimmedField
    private @Size(max=100) String name;
    @Size(max=100)
    @Schema(description="The email address of the contact person of the partner")
    @TrimmedField
    private @Size(max=100) String email;
    @Size(max=100)
    @Schema(description="The phone number of the contact person of the partner")
    @TrimmedField
    private @Size(max=100) String phone;
    @NotNull
    @Schema(description="Automatic partner registry update, this value has no effect on Local partners and will always be false")
    private Boolean automaticPartnerUpdate;
    @NotNull
    @Schema(description="Automatic agreement update when partner is updated from registry, this value has no effect on Local partners and will always be false")
    private Boolean automaticAgreementsUpdate;
    private @NotEmpty @UniqueElements List<@Valid PartyIdDto> partyIds;
    private @NotEmpty List<@Valid TransportDto> transports;
    @NotNull
    @Min(value=1L)
    @Schema(description="This defines the maximum number of parallel message transmissions to the receiver.")
    private @NotNull @Min(value=1L) Integer numberOfParallelDeliveries;
    @NotEmpty
    @MessageTypeConstraint
    private List<String> messageTypeIds;
    @Schema(description="Allow certificate update from received messages.")
    private boolean allowCertificateUpdate;
    private List<@Valid MaintenancePeriodDto> maintenancePeriods = new ArrayList<MaintenancePeriodDto>();

    public String getId() {
        return this.id;
    }

    public PartnerDto setId(String id) {
        this.id = id;
        return this;
    }

    public String getBackendId() {
        return this.backendId;
    }

    public PartnerDto setBackendId(String backendId) {
        this.backendId = backendId;
        return this;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public PartnerDto setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public boolean isRemote() {
        return this.remote;
    }

    public PartnerDto setRemote(boolean remote) {
        this.remote = remote;
        return this;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public PartnerDto setDisabled(boolean disabled) {
        this.disabled = disabled;
        return this;
    }

    public boolean isImported() {
        return this.imported;
    }

    public PartnerDto setImported(boolean imported) {
        this.imported = imported;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public PartnerDto setName(String name) {
        this.name = name;
        return this;
    }

    public String getEmail() {
        return this.email;
    }

    public PartnerDto setEmail(String email) {
        this.email = email;
        return this;
    }

    public String getPhone() {
        return this.phone;
    }

    public PartnerDto setPhone(String phone) {
        this.phone = phone;
        return this;
    }

    public Boolean getAutomaticPartnerUpdate() {
        return this.automaticPartnerUpdate;
    }

    public PartnerDto setAutomaticPartnerUpdate(Boolean automaticPartnerUpdate) {
        this.automaticPartnerUpdate = automaticPartnerUpdate;
        return this;
    }

    public Boolean getAutomaticAgreementsUpdate() {
        return this.automaticAgreementsUpdate;
    }

    public PartnerDto setAutomaticAgreementsUpdate(Boolean automaticAgreementsUpdate) {
        this.automaticAgreementsUpdate = automaticAgreementsUpdate;
        return this;
    }

    public String getDefaultPackager() {
        return this.defaultPackager;
    }

    public PartnerDto setDefaultPackager(String defaultPackager) {
        this.defaultPackager = defaultPackager;
        return this;
    }

    public List<PartyIdDto> getPartyIds() {
        return this.partyIds;
    }

    public PartnerDto setPartyIds(List<PartyIdDto> partyIds) {
        this.partyIds = partyIds;
        return this;
    }

    public List<TransportDto> getTransports() {
        return this.transports;
    }

    public PartnerDto setTransports(List<TransportDto> transports) {
        this.transports = transports;
        return this;
    }

    public Integer getNumberOfParallelDeliveries() {
        return this.numberOfParallelDeliveries;
    }

    public PartnerDto setNumberOfParallelDeliveries(Integer numberOfParallelDeliveries) {
        this.numberOfParallelDeliveries = numberOfParallelDeliveries;
        return this;
    }

    public List<String> getMessageTypeIds() {
        return this.messageTypeIds;
    }

    public PartnerDto setMessageTypeIds(List<String> messageTypeIds) {
        this.messageTypeIds = messageTypeIds;
        return this;
    }

    public List<MaintenancePeriodDto> getMaintenancePeriods() {
        return this.maintenancePeriods;
    }

    public PartnerDto setMaintenancePeriods(List<MaintenancePeriodDto> maintenancePeriods) {
        this.maintenancePeriods = maintenancePeriods;
        return this;
    }

    public boolean isAllowCertificateUpdate() {
        return this.allowCertificateUpdate;
    }

    public PartnerDto setAllowCertificateUpdate(boolean allowCertificateUpdate) {
        this.allowCertificateUpdate = allowCertificateUpdate;
        return this;
    }
}

