/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpa.processing.data;

import java.util.HashMap;
import java.util.Map;

public enum SignatureFormat {
    RAW("raw"),
    PKCS7("PKCS7"),
    SMIME("SMIME");

    private final String name;
    private static final Map<String, SignatureFormat> nameLookup;

    private SignatureFormat(String name) {
        this.name = name;
    }

    public static SignatureFormat of(String name) {
        return nameLookup.get(name);
    }

    public String getName() {
        return this.name;
    }

    public static SignatureFormat ofOptionValue(String optionValue, boolean pkcs7) {
        switch (optionValue) {
            case "MD5withRSA": 
            case "SHA1withRSA": 
            case "SHA512WithRSA": {
                if (pkcs7) {
                    return PKCS7;
                }
                return RAW;
            }
            case "SMIME-SHA1": 
            case "SMIME-SHA512": {
                return SMIME;
            }
        }
        return null;
    }

    static {
        nameLookup = new HashMap<String, SignatureFormat>();
        for (SignatureFormat signatureFormat : SignatureFormat.values()) {
            nameLookup.put(signatureFormat.getName(), signatureFormat);
        }
    }
}

