/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpa.processing.data;

import de.ponton.xmlpipe.rest.cpa.processing.data.SignatureFormat;

public enum HashAlgorithm {
    MD5,
    SHA1,
    SHA512;


    public static HashAlgorithm ofOptionValue(String optionValue) {
        switch (optionValue) {
            case "MD5withRSA": {
                return MD5;
            }
            case "SHA1withRSA": 
            case "SMIME-SHA1": {
                return SHA1;
            }
            case "SHA512WithRSA": 
            case "SMIME-SHA512": {
                return SHA512;
            }
        }
        return null;
    }

    public static String asOptionValue(HashAlgorithm hashAlgorithm, SignatureFormat signatureFormat) {
        if (SignatureFormat.RAW == signatureFormat || SignatureFormat.PKCS7 == signatureFormat) {
            if (MD5 == hashAlgorithm) {
                return "MD5withRSA";
            }
            if (SHA1 == hashAlgorithm) {
                return "SHA1withRSA";
            }
            if (SHA512 == hashAlgorithm) {
                return "SHA512WithRSA";
            }
        } else if (SignatureFormat.SMIME == signatureFormat) {
            if (SHA1 == hashAlgorithm) {
                return "SMIME-SHA1";
            }
            if (SHA512 == hashAlgorithm) {
                return "SMIME-SHA512";
            }
        }
        return null;
    }
}

