/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpa.processing;

import com.fasterxml.jackson.annotation.JsonInclude;
import de.ponton.xmlpipe.rest.cpa.processing.data.HashAlgorithm;
import de.ponton.xmlpipe.rest.cpa.processing.data.SignatureEncryptionAlgorithm;
import de.ponton.xmlpipe.rest.cpa.processing.data.SignatureFormat;
import de.ponton.xmlpipe.rest.cpa.validation.PartnerCertificate;
import de.ponton.xmlpipe.rest.jackson.TrimmedField;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Schema(description="These settings contain the parameter for signing payloads", name="Agreement.Processing.SignPayloads")
public class SignPayloadsDto {
    @NotNull
    @Schema(description="Signature hash algorithm")
    private HashAlgorithm hashAlgorithm;
    @NotNull
    @Schema(description="Signature encryption algorithm")
    private SignatureEncryptionAlgorithm signatureEncryptionAlgorithm;
    @NotNull
    @Schema(description="Format of the signature data")
    private SignatureFormat signatureFormat;
    @PartnerCertificate(remote=false)
    @Schema(description="Identifier of the own partner certificate used for signing the payload")
    @TrimmedField
    private String ownPartnerCertificateId;
    @Schema(description="For the PKCS7 signature format it is possible to include the signing certificate. This results in a larger signature data block, but it allows the receiver to validate the signature even if the certificate is not known by the receiver.")
    private boolean includeSigningCertificate;

    public HashAlgorithm getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public SignPayloadsDto setHashAlgorithm(HashAlgorithm hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
        return this;
    }

    public SignatureEncryptionAlgorithm getSignatureEncryptionAlgorithm() {
        return this.signatureEncryptionAlgorithm;
    }

    public SignPayloadsDto setSignatureEncryptionAlgorithm(SignatureEncryptionAlgorithm signatureEncryptionAlgorithm) {
        this.signatureEncryptionAlgorithm = signatureEncryptionAlgorithm;
        return this;
    }

    public SignatureFormat getSignatureFormat() {
        return this.signatureFormat;
    }

    public SignPayloadsDto setSignatureFormat(SignatureFormat signatureFormat) {
        this.signatureFormat = signatureFormat;
        return this;
    }

    public String getOwnPartnerCertificateId() {
        return this.ownPartnerCertificateId;
    }

    public SignPayloadsDto setOwnPartnerCertificateId(String ownPartnerCertificateId) {
        this.ownPartnerCertificateId = ownPartnerCertificateId;
        return this;
    }

    public boolean isIncludeSigningCertificate() {
        return this.includeSigningCertificate;
    }

    public SignPayloadsDto setIncludeSigningCertificate(boolean includeSigningCertificate) {
        this.includeSigningCertificate = includeSigningCertificate;
        return this;
    }
}

