/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpa.processing;

import de.ponton.xmlpipe.rest.IDtoFactory;
import de.ponton.xmlpipe.rest.cpa.CommunicationsTuple;
import de.ponton.xmlpipe.rest.cpa.modification.XmlModificationDto;
import de.ponton.xmlpipe.rest.cpa.packaging.PipelineUtility;
import de.ponton.xmlpipe.rest.cpa.processing.CompressPayloadsDto;
import de.ponton.xmlpipe.rest.cpa.processing.EncryptPayloadsDto;
import de.ponton.xmlpipe.rest.cpa.processing.ExpectCompressedPayloadsDto;
import de.ponton.xmlpipe.rest.cpa.processing.ExpectEncryptedPayloadsDto;
import de.ponton.xmlpipe.rest.cpa.processing.ExpectSignedPayloadsDto;
import de.ponton.xmlpipe.rest.cpa.processing.ProcessingDto;
import de.ponton.xmlpipe.rest.cpa.processing.ProcessingDtoHolder;
import de.ponton.xmlpipe.rest.cpa.processing.SignPayloadsDto;
import de.ponton.xmlpipe.rest.cpa.processing.data.CharacterEncoding;
import de.ponton.xmlpipe.rest.cpa.processing.data.CompressionAlgorithm;
import de.ponton.xmlpipe.rest.cpa.processing.data.DocTypeProcessing;
import de.ponton.xmlpipe.rest.cpa.processing.data.EncryptionAlgorithm;
import de.ponton.xmlpipe.rest.cpa.processing.data.EncryptionFormat;
import de.ponton.xmlpipe.rest.cpa.processing.data.HashAlgorithm;
import de.ponton.xmlpipe.rest.cpa.processing.data.LineEnding;
import de.ponton.xmlpipe.rest.cpa.processing.data.SignatureEncryptionAlgorithm;
import de.ponton.xmlpipe.rest.cpa.processing.data.SignatureFormat;
import de.pontonconsulting.xmlpipe.config.privatepartneragreement.DoctypeActionType;
import de.pontonconsulting.xmlpipe.config.privatepartneragreement.LineEndingType;
import de.pontonconsulting.xmlpipe.config.privatepartneragreement.XmlEncodingType;
import de.pontonconsulting.xmlpipe.cpa.Communication;
import de.pontonconsulting.xmlpipe.cpp.OptionNotFoundException;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.stereotype.Component;

@Component
public class ProcessingDtoFactory
implements IDtoFactory<ProcessingDtoHolder, CommunicationsTuple> {
    private final PipelineUtility pipelineUtility;

    public ProcessingDtoFactory(PipelineUtility pipelineUtility) {
        this.pipelineUtility = pipelineUtility;
    }

    @Override
    public ProcessingDtoHolder create(CommunicationsTuple communicationsTuple) {
        ProcessingDto processingDto = new ProcessingDto();
        Communication outbound = communicationsTuple.getOutbound();
        this.createSignPayload(outbound, processingDto);
        this.createCompressPayloads(outbound, processingDto);
        this.createEncryptPayloads(outbound, processingDto);
        processingDto.setModifySendingXmlPayloads(this.createXmlModification(outbound));
        this.createAdditionalOutboundParameter(outbound, processingDto);
        Communication inbound = communicationsTuple.getInbound();
        this.createExpectSignedPayloads(inbound, processingDto);
        this.createExpectCompressedPayloads(inbound, processingDto);
        this.createExpectEncryptedPayloads(inbound, processingDto);
        processingDto.setModifyReceivedXmlPayloads(this.createXmlModification(inbound));
        this.createAdditionalInboundParameter(inbound, processingDto);
        return new ProcessingDtoHolder(processingDto, communicationsTuple);
    }

    @Override
    public CommunicationsTuple parse(ProcessingDtoHolder processingDtoHolder) {
        Communication outbound = processingDtoHolder.getCommunicationsTuple().getOutbound();
        this.parseSignPayload(processingDtoHolder.getProcessingDto().getSignPayloads(), outbound);
        this.parseExpectCompressedPayloads(processingDtoHolder.getProcessingDto().getCompressPayloads(), outbound);
        this.parseEncryptPayloads(processingDtoHolder.getProcessingDto().getEncryptPayloads(), outbound);
        this.parseXmlModification(processingDtoHolder.getProcessingDto().getModifySendingXmlPayloads(), outbound);
        this.parseAdditionalOutboundParameter(processingDtoHolder.getProcessingDto(), outbound);
        Communication inbound = processingDtoHolder.getCommunicationsTuple().getInbound();
        this.parseExpectSignedPayloads(processingDtoHolder.getProcessingDto().getExpectSignedPayloads(), inbound);
        this.parseExpectCompressedPayloads(processingDtoHolder.getProcessingDto().getExpectCompressedPayloads(), inbound);
        this.parseExpectEncryptedPayloads(processingDtoHolder.getProcessingDto().getExpectEncryptedPayloads(), inbound);
        this.parseXmlModification(processingDtoHolder.getProcessingDto().getModifyReceivedXmlPayloads(), inbound);
        this.parseAdditionalInboundParameter(processingDtoHolder.getProcessingDto(), inbound);
        return processingDtoHolder.getCommunicationsTuple();
    }

    private void createSignPayload(Communication outbound, ProcessingDto processingDto) {
        AtomicReference signOptionValue = new AtomicReference();
        SignPayloadsDto signPayloadsDto = new SignPayloadsDto();
        this.pipelineUtility.getPipelineOptionValue(outbound, "/sign").ifPresent(value -> {
            signOptionValue.set(value);
            signPayloadsDto.setHashAlgorithm(HashAlgorithm.ofOptionValue(value));
            if (signPayloadsDto.getHashAlgorithm() != null) {
                signPayloadsDto.setSignatureEncryptionAlgorithm(SignatureEncryptionAlgorithm.RSA);
            }
            processingDto.setSignPayloads(signPayloadsDto);
            String pkcsFlag = this.pipelineUtility.getPipelineOptionValue(outbound, "/sign/PKCS7-signed-data").orElse("false");
            signPayloadsDto.setSignatureFormat(SignatureFormat.ofOptionValue((String)signOptionValue.get(), Boolean.parseBoolean(pkcsFlag)));
        });
        this.pipelineUtility.getPipelineOptionValue(outbound, "/sign/certificateAlias").ifPresent(signPayloadsDto::setOwnPartnerCertificateId);
        this.pipelineUtility.getPipelineOptionValue(outbound, "/sign/PKCS7-signed-data/includeCerts").ifPresent(value -> signPayloadsDto.setIncludeSigningCertificate(Boolean.parseBoolean(value)));
    }

    private void parseSignPayload(SignPayloadsDto signPayloadsDto, Communication outbound) {
        if (signPayloadsDto != null) {
            this.pipelineUtility.setPipelineOptionValue(outbound, "/sign", HashAlgorithm.asOptionValue(signPayloadsDto.getHashAlgorithm(), signPayloadsDto.getSignatureFormat()), "string");
            this.pipelineUtility.setPipelineOptionValue(outbound, "/sign/certificateAlias", signPayloadsDto.getOwnPartnerCertificateId(), "string");
            if (SignatureFormat.PKCS7 == signPayloadsDto.getSignatureFormat()) {
                this.pipelineUtility.setPipelineOptionValue(outbound, "/sign/PKCS7-signed-data", Boolean.TRUE, "boolean");
                if (signPayloadsDto.isIncludeSigningCertificate()) {
                    this.pipelineUtility.setPipelineOptionValue(outbound, "/sign/PKCS7-signed-data/includeCerts", signPayloadsDto.isIncludeSigningCertificate(), "boolean");
                }
            }
        } else {
            this.pipelineUtility.removePipelineOptionValue(outbound, "/sign");
        }
    }

    private void createExpectSignedPayloads(Communication inbound, ProcessingDto processingDto) {
        AtomicReference signOptionValue = new AtomicReference();
        ExpectSignedPayloadsDto expectSignedPayloadsDto = new ExpectSignedPayloadsDto();
        this.pipelineUtility.getPipelineOptionValue(inbound, "/sign").ifPresent(value -> {
            signOptionValue.set(value);
            expectSignedPayloadsDto.setHashAlgorithm(HashAlgorithm.ofOptionValue(value));
            if (expectSignedPayloadsDto.getHashAlgorithm() != null) {
                expectSignedPayloadsDto.setSignatureEncryptionAlgorithm(SignatureEncryptionAlgorithm.RSA);
            }
            String pkcsFlag = this.pipelineUtility.getPipelineOptionValue(inbound, "/sign/PKCS7-signed-data").orElse("false");
            expectSignedPayloadsDto.setSignatureFormat(SignatureFormat.ofOptionValue((String)signOptionValue.get(), Boolean.parseBoolean(pkcsFlag)));
            processingDto.setExpectSignedPayloads(expectSignedPayloadsDto);
        });
    }

    private void parseExpectSignedPayloads(ExpectSignedPayloadsDto expectSignedPayloads, Communication inbound) {
        if (expectSignedPayloads != null) {
            this.pipelineUtility.setPipelineOptionValue(inbound, "/sign", HashAlgorithm.asOptionValue(expectSignedPayloads.getHashAlgorithm(), expectSignedPayloads.getSignatureFormat()), "string");
            if (SignatureFormat.PKCS7 == expectSignedPayloads.getSignatureFormat()) {
                this.pipelineUtility.setPipelineOptionValue(inbound, "/sign/PKCS7-signed-data", Boolean.TRUE, "boolean");
            }
        } else {
            this.pipelineUtility.removePipelineOptionValue(inbound, "/sign");
        }
    }

    private void createCompressPayloads(Communication outbound, ProcessingDto processingDto) {
        CompressPayloadsDto compressPayloadsDto = new CompressPayloadsDto();
        this.pipelineUtility.getPipelineOptionValue(outbound, "/Compression").ifPresent(value -> {
            compressPayloadsDto.setAlgorithm(CompressionAlgorithm.of(value));
            processingDto.setCompressPayloads(compressPayloadsDto);
        });
    }

    private void parseExpectCompressedPayloads(CompressPayloadsDto compressPayloadsDto, Communication outbound) {
        if (compressPayloadsDto != null) {
            this.pipelineUtility.setPipelineOptionValue(outbound, "/Compression", compressPayloadsDto.getAlgorithm().getName(), "string");
        } else {
            this.pipelineUtility.removePipelineOptionValue(outbound, "/Compression");
        }
    }

    private void createExpectCompressedPayloads(Communication inbound, ProcessingDto processingDto) {
        ExpectCompressedPayloadsDto expectCompressedPayloadsDto = new ExpectCompressedPayloadsDto();
        this.pipelineUtility.getPipelineOptionValue(inbound, "/Compression").ifPresent(value -> {
            expectCompressedPayloadsDto.setAlgorithm(CompressionAlgorithm.of(value));
            processingDto.setExpectCompressedPayloads(expectCompressedPayloadsDto);
        });
    }

    private void parseExpectCompressedPayloads(ExpectCompressedPayloadsDto expectCompressedPayloadsDto, Communication inbound) {
        if (expectCompressedPayloadsDto != null) {
            this.pipelineUtility.setPipelineOptionValue(inbound, "/Compression", expectCompressedPayloadsDto.getAlgorithm().getName(), "string");
        } else {
            this.pipelineUtility.removePipelineOptionValue(inbound, "/Compression");
        }
    }

    private void createEncryptPayloads(Communication outbound, ProcessingDto processingDto) {
        EncryptPayloadsDto encryptPayloadsDto = new EncryptPayloadsDto();
        this.pipelineUtility.getPipelineOptionValue(outbound, "/Encryption").ifPresent(value -> {
            encryptPayloadsDto.setContentEncryptionAlgorithm(EncryptionAlgorithm.ofOptionValue(value));
            encryptPayloadsDto.setFormat(EncryptionFormat.ofOptionValue(value));
            processingDto.setEncryptPayloads(encryptPayloadsDto);
        });
        this.pipelineUtility.getPipelineOptionValue(outbound, "/Encryption/certificateAlias").ifPresent(encryptPayloadsDto::setCommunicationPartnerCertificateId);
    }

    private void parseEncryptPayloads(EncryptPayloadsDto encryptPayloads, Communication outbound) {
        if (encryptPayloads != null) {
            this.pipelineUtility.setPipelineOptionValue(outbound, "/Encryption", EncryptionAlgorithm.asOptionValue(encryptPayloads.getContentEncryptionAlgorithm(), encryptPayloads.getFormat()), "string");
            this.pipelineUtility.setPipelineOptionValue(outbound, "/Encryption/certificateAlias", encryptPayloads.getCommunicationPartnerCertificateId(), "string");
        } else {
            this.pipelineUtility.removePipelineOptionValue(outbound, "/Encryption");
        }
    }

    private void createExpectEncryptedPayloads(Communication inbound, ProcessingDto processingDto) {
        ExpectEncryptedPayloadsDto expectEncryptedPayloadsDto = new ExpectEncryptedPayloadsDto();
        this.pipelineUtility.getPipelineOptionValue(inbound, "/Encryption").ifPresent(value -> {
            expectEncryptedPayloadsDto.setContentEncryptionAlgorithm(EncryptionAlgorithm.ofOptionValue(value));
            expectEncryptedPayloadsDto.setFormat(EncryptionFormat.ofOptionValue(value));
            processingDto.setExpectEncryptedPayloads(expectEncryptedPayloadsDto);
        });
    }

    private void parseExpectEncryptedPayloads(ExpectEncryptedPayloadsDto expectEncryptedPayloads, Communication inbound) {
        if (expectEncryptedPayloads != null) {
            this.pipelineUtility.setPipelineOptionValue(inbound, "/Encryption", EncryptionAlgorithm.asOptionValue(expectEncryptedPayloads.getContentEncryptionAlgorithm(), expectEncryptedPayloads.getFormat()), "string");
        } else {
            this.pipelineUtility.removePipelineOptionValue(inbound, "/Encryption");
        }
    }

    private XmlModificationDto createXmlModification(Communication communication) {
        if (communication.getXmlModificationEnabled()) {
            return new XmlModificationDto().setUpdatePapiNet1Envelope(communication.getUpdatePapinet1Envelope()).setDoctype(DocTypeProcessing.ofOptionValue(communication.getDoctypeAction())).setChangeCharacterEncoding(CharacterEncoding.of(communication.getXmlEncoding())).setChangeLineEnding(LineEnding.ofOptionValue(communication.getLineEnding())).setReformatXML(communication.getPrettyPrint());
        }
        return null;
    }

    private void parseXmlModification(XmlModificationDto xmlModification, Communication communication) {
        if (xmlModification != null) {
            communication.setXmlModificationEnabled(true);
            if (xmlModification.getChangeCharacterEncoding() != null) {
                communication.setXmlEncoding(xmlModification.getChangeCharacterEncoding().getName());
            } else {
                communication.setXmlEncoding(XmlEncodingType.NO_CHANGE.value());
            }
            if (xmlModification.getChangeLineEnding() != null) {
                communication.setLineEnding(LineEnding.asOptionValue(xmlModification.getChangeLineEnding()));
            } else {
                communication.setLineEnding(LineEndingType.NO_CHANGE.value());
            }
            communication.setPrettyPrint(xmlModification.isReformatXML());
            communication.setUpdatePapinet1Envelope(xmlModification.isUpdatePapiNet1Envelope());
            if (xmlModification.getDoctype() != null) {
                communication.setDoctypeAction(DocTypeProcessing.asOptionValue(xmlModification.getDoctype()));
            } else {
                communication.setDoctypeAction(DoctypeActionType.NO_CHANGE.value());
            }
        } else {
            communication.setXmlModificationEnabled(false);
        }
    }

    private void createAdditionalOutboundParameter(Communication outbound, ProcessingDto processingDto) {
        try {
            processingDto.setValidateTransmittedPayloads(Boolean.parseBoolean(outbound.getPipelineOptionValue("/validation")));
        }
        catch (OptionNotFoundException optionNotFoundException) {
            // empty catch block
        }
        try {
            processingDto.setCreateEnergylinkXmlFormat(Boolean.parseBoolean(outbound.getPipelineOptionValue("/edaXmlSec")));
        }
        catch (OptionNotFoundException optionNotFoundException) {
            // empty catch block
        }
        try {
            processingDto.setCustomValidationOnTransmittedPayloads(Boolean.parseBoolean(outbound.getPipelineOptionValue("/customValidation")));
        }
        catch (OptionNotFoundException optionNotFoundException) {
            // empty catch block
        }
    }

    private void parseAdditionalOutboundParameter(ProcessingDto processingDto, Communication outbound) {
        this.pipelineUtility.setPipelineOptionValue(outbound, "/validation", processingDto.isValidateTransmittedPayloads(), "boolean");
        this.pipelineUtility.setPipelineOptionValue(outbound, "/edaXmlSec", processingDto.isCreateEnergylinkXmlFormat(), "boolean");
        this.pipelineUtility.setPipelineOptionValue(outbound, "/customValidation", processingDto.isCustomValidationOnTransmittedPayloads(), "boolean");
    }

    private void createAdditionalInboundParameter(Communication inbound, ProcessingDto processingDto) {
        try {
            processingDto.setValidateReceivedPayloads(Boolean.parseBoolean(inbound.getPipelineOptionValue("/validation")));
        }
        catch (OptionNotFoundException optionNotFoundException) {
            // empty catch block
        }
        try {
            processingDto.setProcessEnergylinkXmlFormat(Boolean.parseBoolean(inbound.getPipelineOptionValue("/edaXmlSec")));
        }
        catch (OptionNotFoundException optionNotFoundException) {
            // empty catch block
        }
        try {
            processingDto.setCustomValidationOnReceivedPayloads(Boolean.parseBoolean(inbound.getPipelineOptionValue("/customValidation")));
        }
        catch (OptionNotFoundException optionNotFoundException) {
            // empty catch block
        }
    }

    private void parseAdditionalInboundParameter(ProcessingDto processingDto, Communication inbound) {
        this.pipelineUtility.setPipelineOptionValue(inbound, "/validation", processingDto.isValidateReceivedPayloads(), "boolean");
        this.pipelineUtility.setPipelineOptionValue(inbound, "/edaXmlSec", processingDto.isProcessEnergylinkXmlFormat(), "boolean");
        this.pipelineUtility.setPipelineOptionValue(inbound, "/customValidation", processingDto.isCustomValidationOnReceivedPayloads(), "boolean");
    }
}

