/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpa.packaging.as123.data;

import de.ponton.xmlpipe.rest.cpa.packaging.as123.data.HashAlgorithm;

public enum SignatureEncryptionAlgorithm {
    ECDSA,
    RSA,
    RSASSA_PSS;


    public static SignatureEncryptionAlgorithm ofOptionValue(String optionValue) {
        switch (optionValue) {
            case "SHA-256/ECDSA signed": 
            case "SHA-384/ECDSA signed": 
            case "SHA-512/ECDSA signed": {
                return ECDSA;
            }
            case "MD5 signed": 
            case "SHA-1 signed": 
            case "SHA-224 signed": 
            case "SHA-256 signed": 
            case "SHA-384 signed": 
            case "SHA-512 signed": {
                return RSA;
            }
            case "SHA-1/PSS signed": 
            case "SHA-224/PSS signed": 
            case "SHA-256/PSS signed": 
            case "SHA-384/PSS signed": 
            case "SHA-512/PSS signed": {
                return RSASSA_PSS;
            }
        }
        return null;
    }

    public static String asOptionValue(HashAlgorithm hashAlgorithm, SignatureEncryptionAlgorithm signatureEncryptionAlgorithm) {
        switch (signatureEncryptionAlgorithm.ordinal()) {
            case 0: {
                switch (hashAlgorithm) {
                    case SHA256: {
                        return "SHA-256/ECDSA signed";
                    }
                    case SHA384: {
                        return "SHA-384/ECDSA signed";
                    }
                    case SHA512: {
                        return "SHA-512/ECDSA signed";
                    }
                }
                return null;
            }
            case 1: {
                switch (hashAlgorithm) {
                    case SHA1: {
                        return "SHA-1 signed";
                    }
                    case SHA256: {
                        return "SHA-256 signed";
                    }
                    case SHA384: {
                        return "SHA-384 signed";
                    }
                    case SHA512: {
                        return "SHA-512 signed";
                    }
                }
                return null;
            }
            case 2: {
                switch (hashAlgorithm) {
                    case SHA1: {
                        return "SHA-1/PSS signed";
                    }
                    case SHA256: {
                        return "SHA-256/PSS signed";
                    }
                    case SHA384: {
                        return "SHA-384/PSS signed";
                    }
                    case SHA512: {
                        return "SHA-512/PSS signed";
                    }
                }
                return null;
            }
        }
        return null;
    }
}

