/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpa.packaging;

import de.ponton.xmlpipe.rest.IDtoFactory;
import de.ponton.xmlpipe.rest.cpa.CommunicationsTuple;
import de.ponton.xmlpipe.rest.cpa.packaging.PackagingDtoHolder;
import de.ponton.xmlpipe.rest.cpa.packaging.PackagingUtility;
import de.ponton.xmlpipe.rest.cpa.packaging.PlainPackagingDto;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class PlainPackagingDtoFactory
implements IDtoFactory<PackagingDtoHolder<PlainPackagingDto>, CommunicationsTuple> {
    private final PackagingUtility packagingUtility;

    public PlainPackagingDtoFactory(PackagingUtility packagingUtility) {
        this.packagingUtility = packagingUtility;
    }

    @Override
    public PackagingDtoHolder<PlainPackagingDto> create(CommunicationsTuple communicationsTuple) {
        PlainPackagingDto packagingDto = new PlainPackagingDto();
        PackagingDtoHolder<PlainPackagingDto> dtoHolder = new PackagingDtoHolder<PlainPackagingDto>().setPackagingDto(packagingDto).setCommunicationsTuple(communicationsTuple);
        this.packagingUtility.getPackagingOptionValue(communicationsTuple.getInbound(), "/password").ifPresent(packagingDto::setPassword);
        this.packagingUtility.getPackagingOptionValue(communicationsTuple.getOutbound(), "/RequestACK").ifPresent(value -> packagingDto.setConvertTransmissionResultToAcknowledgements(Boolean.parseBoolean(value)));
        return dtoHolder;
    }

    @Override
    public CommunicationsTuple parse(PackagingDtoHolder<PlainPackagingDto> dtoHolder) {
        if (StringUtils.isNotBlank((CharSequence)dtoHolder.getPackagingDto().getPassword()) && !"***".equals(dtoHolder.getPackagingDto().getPassword())) {
            this.packagingUtility.setPackagingOptionValue(dtoHolder.getCommunicationsTuple().getInbound(), "/password", dtoHolder.getPackagingDto().getPassword(), "string");
        } else if (!"***".equals(dtoHolder.getPackagingDto().getPassword())) {
            this.packagingUtility.removePackagingOptionValue(dtoHolder.getCommunicationsTuple().getInbound(), "/password");
        }
        this.packagingUtility.setPackagingOptionValue(dtoHolder.getCommunicationsTuple().getOutbound(), "/RequestACK", dtoHolder.getPackagingDto().getConvertTransmissionResultToAcknowledgements(), "boolean");
        return dtoHolder.getCommunicationsTuple();
    }
}

