/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpa.packaging;

import de.ponton.xmlpipe.rest.IDtoFactory;
import de.ponton.xmlpipe.rest.cpa.CommunicationsTuple;
import de.ponton.xmlpipe.rest.cpa.packaging.AS4PackagingDto;
import de.ponton.xmlpipe.rest.cpa.packaging.PackagingDtoHolder;
import de.ponton.xmlpipe.rest.cpa.packaging.PackagingUtility;
import de.ponton.xmlpipe.rest.cpa.packaging.as123.data.ContentEncryptionAlgorithm;
import de.ponton.xmlpipe.rest.cpa.packaging.as123.data.KeyEncryptionAlgorithm;
import de.ponton.xmlpipe.rest.cpa.packaging.as4.AgreementReferenceDto;
import de.ponton.xmlpipe.rest.cpa.packaging.as4.EncryptMessagesDto;
import de.ponton.xmlpipe.rest.cpa.packaging.as4.ExpectEncryptedMessagesDto;
import de.ponton.xmlpipe.rest.cpa.packaging.as4.ExpectReceiptsDto;
import de.ponton.xmlpipe.rest.cpa.packaging.as4.ExpectSignedDto;
import de.ponton.xmlpipe.rest.cpa.packaging.as4.SendReceiptsDto;
import de.ponton.xmlpipe.rest.cpa.packaging.as4.ServiceDto;
import de.ponton.xmlpipe.rest.cpa.packaging.as4.SigningDto;
import de.ponton.xmlpipe.rest.cpa.packaging.as4.data.HashAlgorithm;
import de.ponton.xmlpipe.rest.cpa.packaging.as4.data.KeyEncryptionMethod;
import de.ponton.xmlpipe.rest.cpa.packaging.as4.data.KeyInformation;
import de.ponton.xmlpipe.rest.cpa.packaging.as4.data.MessageProperty;
import de.ponton.xmlpipe.rest.cpa.packaging.as4.data.SignatureEncryptionAlgorithm;
import de.ponton.xmlpipe.rest.cpa.packaging.as4.data.SigningKeyInformation;
import de.pontonconsulting.xmlpipe.cp.Option;
import de.pontonconsulting.xmlpipe.cpa.Communication;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class AS4PackagingDtoFactory
implements IDtoFactory<PackagingDtoHolder<AS4PackagingDto>, CommunicationsTuple> {
    private final PackagingUtility packagingUtility;

    public AS4PackagingDtoFactory(PackagingUtility packagingUtility) {
        this.packagingUtility = packagingUtility;
    }

    @Override
    public PackagingDtoHolder<AS4PackagingDto> create(CommunicationsTuple communicationsTuple) {
        AS4PackagingDto packagingDto = new AS4PackagingDto();
        Communication outbound = communicationsTuple.getOutbound();
        Communication inbound = communicationsTuple.getInbound();
        this.packagingUtility.getPackagingOptionValue(outbound, "/RoleFrom").ifPresent(packagingDto::setRoleFrom);
        this.packagingUtility.getPackagingOptionValue(outbound, "/RoleTo").ifPresent(packagingDto::setRoleTo);
        ServiceDto serviceDto = new ServiceDto();
        this.packagingUtility.getPackagingOptionValue(outbound, "/Service").ifPresent(value -> {
            serviceDto.setValue((String)value);
            packagingDto.setService(serviceDto);
        });
        this.packagingUtility.getPackagingOptionValue(outbound, "/Service/Type").ifPresent(serviceDto::setType);
        this.packagingUtility.getPackagingOptionValue(outbound, "/Action").ifPresent(packagingDto::setAction);
        this.packagingUtility.getPackagingOptionValue(outbound, "/CID").ifPresent(packagingDto::setCid);
        AgreementReferenceDto agreementReferenceDto = new AgreementReferenceDto();
        this.packagingUtility.getPackagingOptionValue(outbound, "/AgreementRef").ifPresent(value -> {
            agreementReferenceDto.setValue((String)value);
            packagingDto.setAgreementReference(agreementReferenceDto);
        });
        this.packagingUtility.getPackagingOptionValue(outbound, "/AgreementRef/Type").ifPresent(agreementReferenceDto::setType);
        this.packagingUtility.getPackagingOptionValue(outbound, "/AgreementRef/PMode").ifPresent(agreementReferenceDto::setPmode);
        this.packagingUtility.getPackagingOptionValue(outbound, "/IncludeMessageProperties").ifPresent(value -> packagingDto.setIncludeMessageProperties(Boolean.parseBoolean(value)));
        this.packagingUtility.getChildOptions(outbound, "/IncludeMessageProperties").forEach(option -> packagingDto.getMessageProperties().add(new MessageProperty().setName(option.getName()).setValue(option.getValue())));
        this.packagingUtility.getPackagingOptionValue(outbound, "/IncludeContentProperties").ifPresent(value -> packagingDto.setIncludeContentProperties(Boolean.parseBoolean(value)));
        this.packagingUtility.getChildOptions(outbound, "/IncludeContentProperties").forEach(option -> packagingDto.getContentProperties().add(new MessageProperty().setName(option.getName()).setValue(option.getValue())));
        this.packagingUtility.getPackagingOptionValue(outbound, "/CertificateUpdate").ifPresent(value -> packagingDto.setEnableCertificateUpdateMessages(Boolean.parseBoolean(value)));
        SigningDto signMessageDto = new SigningDto();
        this.packagingUtility.getPackagingOptionValue(outbound, "/SignMessage").ifPresent(value -> {
            signMessageDto.setHashAlgorithm(HashAlgorithm.ofOptionValue(value)).setSignatureEncryptionAlgorithm(SignatureEncryptionAlgorithm.ofOptionValue(value));
            packagingDto.setSignMessages(signMessageDto);
        });
        SigningKeyInformation signMessageSigningKeyInformation = SigningKeyInformation.of(this.packagingUtility.getPackagingOptionValue(outbound, "/SignMessage/KeyInfo").orElse(""));
        signMessageDto.setSigningKeyInformation(signMessageSigningKeyInformation == null ? SigningKeyInformation.ISSUER_AND_SERIAL_NUMBER : signMessageSigningKeyInformation);
        this.packagingUtility.getPackagingOptionValue(outbound, "/SignMessage/certificateAlias").ifPresent(signMessageDto::setOwnPartnerCertificateId);
        EncryptMessagesDto encryptMessagesDto = new EncryptMessagesDto();
        this.packagingUtility.getPackagingOptionValue(outbound, "/EncryptMessage").ifPresent(value -> {
            encryptMessagesDto.setContentEncryptionAlgorithm(ContentEncryptionAlgorithm.ofOptionValueAS4(value));
            packagingDto.setEncryptMessages(encryptMessagesDto);
        });
        this.packagingUtility.getPackagingOptionValue(outbound, "/EncryptMessage/certificateAlias").ifPresent(encryptMessagesDto::setCommunicationPartnerCertificateId);
        KeyInformation encryptionKeyInformation = KeyInformation.of(this.packagingUtility.getPackagingOptionValue(outbound, "/EncryptMessage/KeyInfo").orElse(""));
        encryptMessagesDto.setEncryptionKeyInformation(encryptionKeyInformation == null ? KeyInformation.ISSUER_AND_SERIAL_NUMBER : encryptionKeyInformation);
        Optional<String> keyEncryptionOption = this.packagingUtility.getPackagingOptionValue(outbound, "/EncryptMessage/KeyEncryption");
        if (keyEncryptionOption.isPresent()) {
            encryptMessagesDto.setKeyEncryptionMethod(KeyEncryptionMethod.of(keyEncryptionOption.get()));
        } else {
            String templateId = inbound.getAgreement().getTemplateId();
            if ("AS4-BDEW".equals(templateId)) {
                encryptMessagesDto.setKeyEncryptionMethod(KeyEncryptionMethod.ECDH_ES_CONCATKDF_EMPTY_SHA256);
            } else {
                encryptMessagesDto.setKeyEncryptionMethod(KeyEncryptionMethod.RSA_OAEP_SHA1);
            }
        }
        ExpectSignedDto expectSignedMessageDto = new ExpectSignedDto();
        this.packagingUtility.getPackagingOptionValue(inbound, "/ExpectSignedMessage").ifPresent(value -> {
            expectSignedMessageDto.setHashAlgorithm(HashAlgorithm.ofOptionValue(value)).setSignatureEncryptionAlgorithm(SignatureEncryptionAlgorithm.ofOptionValue(value));
            packagingDto.setExpectSignedMessages(expectSignedMessageDto);
        });
        ExpectEncryptedMessagesDto expectEncryptedMessagesDto = new ExpectEncryptedMessagesDto();
        this.packagingUtility.getPackagingOptionValue(inbound, "/ExpectEncryptedMessage").ifPresent(value -> {
            expectEncryptedMessagesDto.setContentEncryptionAlgorithm(ContentEncryptionAlgorithm.ofOptionValueAS4(value));
            packagingDto.setExpectEncryptedMessages(expectEncryptedMessagesDto);
        });
        this.packagingUtility.getPackagingOptionValue(outbound, "/CompressContent").ifPresent(value -> packagingDto.setCompressMessages(Boolean.parseBoolean(value)));
        this.packagingUtility.getPackagingOptionValue(inbound, "/ExpectCompressedContent").ifPresent(value -> packagingDto.setExpectCompressedMessages(Boolean.parseBoolean(value)));
        this.packagingUtility.getPackagingOptionValue(outbound, "/ExpectReceipt").ifPresent(value -> {
            ExpectReceiptsDto expectReceiptsDto = new ExpectReceiptsDto();
            if (!"unsigned".equals(value)) {
                ExpectSignedDto expectSignedReceipts = new ExpectSignedDto().setHashAlgorithm(HashAlgorithm.ofOptionValue(value)).setSignatureEncryptionAlgorithm(SignatureEncryptionAlgorithm.ofOptionValue(value));
                expectReceiptsDto.setExpectSignedReceipts(expectSignedReceipts);
            }
            packagingDto.setExpectReceipts(expectReceiptsDto);
        });
        SendReceiptsDto sendReceiptsDto = new SendReceiptsDto();
        SigningDto signReceiptsDto = new SigningDto();
        this.packagingUtility.getPackagingOptionValue(inbound, "/SendReceipt").ifPresent(value -> {
            if (!"unsigned".equals(value)) {
                signReceiptsDto.setHashAlgorithm(HashAlgorithm.ofOptionValue(value)).setSignatureEncryptionAlgorithm(SignatureEncryptionAlgorithm.ofOptionValue(value));
                sendReceiptsDto.setSignReceipts(signReceiptsDto);
            }
            packagingDto.setSendReceipts(sendReceiptsDto);
        });
        this.packagingUtility.getPackagingOptionValue(inbound, "/SendReceipt/certificateAlias").ifPresent(signReceiptsDto::setOwnPartnerCertificateId);
        SigningKeyInformation signReceiptsSigningKeyInformation = SigningKeyInformation.of(this.packagingUtility.getPackagingOptionValue(inbound, "/SendReceipt/KeyInfo").orElse(""));
        signReceiptsDto.setSigningKeyInformation(signReceiptsSigningKeyInformation == null ? SigningKeyInformation.ISSUER_AND_SERIAL_NUMBER : signReceiptsSigningKeyInformation);
        this.packagingUtility.getPackagingOptionValue(inbound, "/SendReceipt/SyncReply").ifPresent(value -> sendReceiptsDto.setSendSynchronously(Boolean.parseBoolean(value)));
        this.packagingUtility.getPackagingOptionValue(inbound, "/DuplicateElimination").ifPresent(value -> packagingDto.setIgnoreDuplicateMessages(Boolean.parseBoolean(value)));
        this.packagingUtility.getPackagingOptionValue(outbound, "/EmptyConversationId").ifPresent(value -> packagingDto.setEmptyConversationId(Boolean.parseBoolean(value)));
        return new PackagingDtoHolder<AS4PackagingDto>(packagingDto, communicationsTuple);
    }

    @Override
    public CommunicationsTuple parse(PackagingDtoHolder<AS4PackagingDto> packagingDtoHolder) {
        AS4PackagingDto packagingDto = packagingDtoHolder.getPackagingDto();
        Communication inbound = packagingDtoHolder.getCommunicationsTuple().getInbound();
        Communication outbound = packagingDtoHolder.getCommunicationsTuple().getOutbound();
        this.packagingUtility.setPackagingOptionValue(outbound, "/RoleFrom", packagingDto.getRoleFrom(), "string");
        this.packagingUtility.setPackagingOptionValue(outbound, "/RoleTo", packagingDto.getRoleTo(), "string");
        if (packagingDto.getService() != null) {
            this.packagingUtility.setPackagingOptionValue(outbound, "/Service", packagingDto.getService().getValue(), "string");
            this.packagingUtility.setPackagingOptionValue(outbound, "/Service/Type", packagingDto.getService().getType(), "string");
        } else {
            this.packagingUtility.removePackagingOptionValue(outbound, "/Service");
            this.packagingUtility.removePackagingOptionValue(outbound, "/Service/Type");
        }
        this.packagingUtility.setPackagingOptionValue(outbound, "/Action", packagingDto.getAction(), "string");
        this.packagingUtility.setPackagingOptionValue(outbound, "/CID", packagingDto.getCid(), "string");
        if (packagingDto.getAgreementReference() != null) {
            this.packagingUtility.setPackagingOptionValue(outbound, "/AgreementRef", packagingDto.getAgreementReference().getValue(), "string");
            this.packagingUtility.setPackagingOptionValue(outbound, "/AgreementRef/Type", packagingDto.getAgreementReference().getType(), "string");
            this.packagingUtility.setPackagingOptionValue(outbound, "/AgreementRef/PMode", packagingDto.getAgreementReference().getPmode(), "string");
        } else {
            this.packagingUtility.removePackagingOptionValue(outbound, "/AgreementRef");
            this.packagingUtility.removePackagingOptionValue(outbound, "/AgreementRef/Type");
            this.packagingUtility.removePackagingOptionValue(outbound, "/AgreementRef/PMode");
        }
        this.packagingUtility.setPackagingOptionValue(outbound, "/IncludeMessageProperties", packagingDto.isIncludeMessageProperties(), "boolean");
        this.packagingUtility.setChildOption(outbound, "/IncludeMessageProperties", (Option[])packagingDto.getMessageProperties().stream().map(option -> new Option(option.getName(), option.getValue(), "string")).toArray(Option[]::new));
        this.packagingUtility.setPackagingOptionValue(outbound, "/IncludeContentProperties", packagingDto.isIncludeContentProperties(), "boolean");
        this.packagingUtility.setChildOption(outbound, "/IncludeContentProperties", (Option[])packagingDto.getContentProperties().stream().map(option -> new Option(option.getName(), option.getValue(), "string")).toArray(Option[]::new));
        this.packagingUtility.setPackagingOptionValue(outbound, "/CertificateUpdate", packagingDto.isEnableCertificateUpdateMessages(), "boolean");
        if (packagingDto.getSignMessages() != null) {
            this.packagingUtility.setPackagingOptionValue(outbound, "/SignMessage", SignatureEncryptionAlgorithm.asOptionValue(packagingDto.getSignMessages().getHashAlgorithm(), packagingDto.getSignMessages().getSignatureEncryptionAlgorithm()), "string");
            this.packagingUtility.setPackagingOptionValue(outbound, "/SignMessage/KeyInfo", packagingDto.getSignMessages().getSigningKeyInformation().getName(), "string");
            this.packagingUtility.setPackagingOptionValue(outbound, "/SignMessage/certificateAlias", packagingDto.getSignMessages().getOwnPartnerCertificateId(), "string");
        } else {
            this.packagingUtility.removePackagingOptionValue(outbound, "/SignMessage");
            this.packagingUtility.removePackagingOptionValue(outbound, "/SignMessage/KeyInfo");
            this.packagingUtility.removePackagingOptionValue(outbound, "/SignMessage/certificateAlias");
        }
        if (packagingDto.getExpectSignedMessages() != null) {
            this.packagingUtility.setPackagingOptionValue(inbound, "/ExpectSignedMessage", SignatureEncryptionAlgorithm.asOptionValue(packagingDto.getExpectSignedMessages().getHashAlgorithm(), packagingDto.getExpectSignedMessages().getSignatureEncryptionAlgorithm()), "string");
        } else {
            this.packagingUtility.removePackagingOptionValue(inbound, "/ExpectSignedMessage");
        }
        if (packagingDto.getEncryptMessages() != null) {
            this.packagingUtility.setPackagingOptionValue(outbound, "/EncryptMessage", ContentEncryptionAlgorithm.asOptionValueAS4(packagingDto.getEncryptMessages().getContentEncryptionAlgorithm(), KeyEncryptionAlgorithm.RSA), "string");
            this.packagingUtility.setPackagingOptionValue(outbound, "/EncryptMessage/certificateAlias", packagingDto.getEncryptMessages().getCommunicationPartnerCertificateId(), "string");
            this.packagingUtility.setPackagingOptionValue(outbound, "/EncryptMessage/KeyInfo", packagingDto.getEncryptMessages().getEncryptionKeyInformation().getName(), "string");
            Optional.ofNullable(packagingDto.getEncryptMessages().getKeyEncryptionMethod()).ifPresentOrElse(keyEncryptionMethod -> this.packagingUtility.setPackagingOptionValue(outbound, "/EncryptMessage/KeyEncryption", keyEncryptionMethod.getName(), "string"), () -> this.packagingUtility.removePackagingOptionValue(outbound, "/EncryptMessage/KeyEncryption"));
        } else {
            this.packagingUtility.removePackagingOptionValue(outbound, "/EncryptMessage/certificateAlias");
            this.packagingUtility.removePackagingOptionValue(outbound, "/EncryptMessage/KeyInfo");
            this.packagingUtility.removePackagingOptionValue(outbound, "/EncryptMessage/KeyEncryption");
            this.packagingUtility.removePackagingOptionValue(outbound, "/EncryptMessage");
        }
        if (packagingDto.getExpectEncryptedMessages() != null) {
            this.packagingUtility.setPackagingOptionValue(inbound, "/ExpectEncryptedMessage", ContentEncryptionAlgorithm.asOptionValueAS4(packagingDto.getExpectEncryptedMessages().getContentEncryptionAlgorithm(), KeyEncryptionAlgorithm.RSA), "string");
        } else {
            this.packagingUtility.removePackagingOptionValue(inbound, "/ExpectEncryptedMessage");
        }
        this.packagingUtility.setPackagingOptionValue(outbound, "/CompressContent", packagingDto.isCompressMessages(), "boolean");
        this.packagingUtility.setPackagingOptionValue(inbound, "/ExpectCompressedContent", packagingDto.isExpectCompressedMessages(), "boolean");
        if (packagingDto.getExpectReceipts() != null) {
            if (packagingDto.getExpectReceipts().getExpectSignedReceipts() != null) {
                this.packagingUtility.setPackagingOptionValue(outbound, "/ExpectReceipt", SignatureEncryptionAlgorithm.asOptionValue(packagingDto.getExpectReceipts().getExpectSignedReceipts().getHashAlgorithm(), packagingDto.getExpectReceipts().getExpectSignedReceipts().getSignatureEncryptionAlgorithm()), "string");
            } else {
                this.packagingUtility.setPackagingOptionValue(outbound, "/ExpectReceipt", "unsigned", "string");
            }
        } else {
            this.packagingUtility.removePackagingOptionValue(outbound, "/ExpectReceipt");
        }
        if (packagingDto.getSendReceipts() != null) {
            if (packagingDto.getSendReceipts().getSignReceipts() != null) {
                this.packagingUtility.setPackagingOptionValue(inbound, "/SendReceipt", SignatureEncryptionAlgorithm.asOptionValue(packagingDto.getSendReceipts().getSignReceipts().getHashAlgorithm(), packagingDto.getSendReceipts().getSignReceipts().getSignatureEncryptionAlgorithm()), "string");
                this.packagingUtility.setPackagingOptionValue(inbound, "/SendReceipt/KeyInfo", packagingDto.getSendReceipts().getSignReceipts().getSigningKeyInformation().getName(), "string");
                this.packagingUtility.setPackagingOptionValue(inbound, "/SendReceipt/certificateAlias", packagingDto.getSendReceipts().getSignReceipts().getOwnPartnerCertificateId(), "string");
            } else {
                this.packagingUtility.setPackagingOptionValue(inbound, "/SendReceipt", "unsigned", "string");
            }
            this.packagingUtility.setPackagingOptionValue(inbound, "/SendReceipt/SyncReply", packagingDto.getSendReceipts().isSendSynchronously(), "boolean");
        } else {
            this.packagingUtility.removePackagingOptionValue(inbound, "/SendReceipt");
            this.packagingUtility.removePackagingOptionValue(inbound, "/SendReceipt/certificateAlias");
            this.packagingUtility.removePackagingOptionValue(inbound, "/SendReceipt/SyncReply");
            this.packagingUtility.removePackagingOptionValue(inbound, "/SendReceipt/KeyInfo");
        }
        this.packagingUtility.setPackagingOptionValue(inbound, "/DuplicateElimination", packagingDto.isIgnoreDuplicateMessages(), "boolean");
        this.packagingUtility.setPackagingOptionValue(outbound, "/EmptyConversationId", packagingDto.isEmptyConversationId(), "boolean");
        return packagingDtoHolder.getCommunicationsTuple();
    }
}

