/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpa.integration;

import de.ponton.xmlpipe.rest.IDtoFactory;
import de.ponton.xmlpipe.rest.cpa.integration.IntegrationDto;
import de.ponton.xmlpipe.rest.cpa.integration.IntegrationDtoHolder;
import de.ponton.xmlpipe.rest.cpa.rules.IntegrationRuleDataDtoFactory;
import de.ponton.xmlpipe.rest.exception.ResourceNotFoundException;
import de.pontonconsulting.xmlpipe.cpa.Agreement;
import de.pontonconsulting.xmlpipe.cpa.Communication;
import de.pontonconsulting.xmlpipe.cpa.CommunicationNotFoundException;
import de.pontonconsulting.xmlpipe.cpa.RuleData;
import java.util.ArrayList;
import java.util.Arrays;
import org.springframework.stereotype.Component;

@Component
public class IntegrationDtoFactory
implements IDtoFactory<IntegrationDtoHolder, Agreement> {
    private final IntegrationRuleDataDtoFactory ruleDataDtoFactory;

    public IntegrationDtoFactory(IntegrationRuleDataDtoFactory ruleDataDtoFactory) {
        this.ruleDataDtoFactory = ruleDataDtoFactory;
    }

    @Override
    public IntegrationDtoHolder create(Agreement agreement) {
        IntegrationDto integrationDto = new IntegrationDto().setDefaultAdapter(agreement.getDefaultAdapterId());
        try {
            Communication inbound = agreement.getCommunication(agreement.getPartner2LocalId(), agreement.getPartner1LocalId());
            Arrays.stream(inbound.getContentRules()).map(this.ruleDataDtoFactory::create).peek(ruleData -> ruleData.setActionType("ChangeDestinationAdapter")).forEach(integrationDto::addRule);
        }
        catch (CommunicationNotFoundException e) {
            throw new ResourceNotFoundException(e);
        }
        return new IntegrationDtoHolder(agreement, integrationDto);
    }

    @Override
    public Agreement parse(IntegrationDtoHolder integrationDtoHolder) {
        Agreement agreement = integrationDtoHolder.getAgreement();
        IntegrationDto integrationDto = integrationDtoHolder.getIntegrationDto();
        try {
            Communication inbound = agreement.getCommunication(agreement.getPartner2LocalId(), agreement.getPartner1LocalId());
            agreement.setDefaultAdapterId(integrationDto.getDefaultAdapter());
            ArrayList inboundContentRules = new ArrayList();
            integrationDto.getRules().stream().peek(ruleDataDto -> ruleDataDto.setIndex(inboundContentRules.size() + 1)).map(this.ruleDataDtoFactory::parse).peek(ruleData -> ruleData.setActionType("ChangeDestinationAdapter")).forEach(inboundContentRules::add);
            inbound.setContentRules(inboundContentRules.toArray(new RuleData[0]));
        }
        catch (CommunicationNotFoundException e) {
            throw new ResourceNotFoundException(e);
        }
        return agreement;
    }
}

