/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpa;

import com.fasterxml.jackson.annotation.JsonFormat;
import de.ponton.xmlpipe.rest.jackson.TrimmedField;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.OffsetDateTime;
import org.springframework.validation.annotation.Validated;

@Validated
@Schema(description="An Agreement defines the communication between two partners. This item is for an overview to be displayed e.g. in a table.", name="AgreementListItem")
public class AgreementListItemDto {
    @Schema(description="The id of the Agreement")
    @TrimmedField
    private String agreementId;
    @Schema(description="The local id of the local partner")
    @TrimmedField
    private String localPartnerId;
    @Schema(description="The display name of the local partner")
    @TrimmedField
    private String localPartnerDisplayName;
    @Schema(description="The technical backend id of the local partner")
    @TrimmedField
    private String localPartnerBackendId;
    @Schema(description="The local id of the remote partner")
    @TrimmedField
    private String remotePartnerId;
    @Schema(description="The display name of the remote partner")
    @TrimmedField
    private String remotePartnerDisplayName;
    @Schema(description="The technical backend id of the remote partner")
    @TrimmedField
    private String remotePartnerBackendId;
    @Schema(description="The id of the adapter used by this agreement")
    @TrimmedField
    private String adapterId;
    @Schema(description="The name of the packager used by this agreement")
    @TrimmedField
    private String packagerName;
    @Schema(description="The date and time of the last modification of this agreement")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
    private OffsetDateTime lastModified;

    public String getAgreementId() {
        return this.agreementId;
    }

    public AgreementListItemDto setAgreementId(String agreementId) {
        this.agreementId = agreementId;
        return this;
    }

    public String getLocalPartnerId() {
        return this.localPartnerId;
    }

    public AgreementListItemDto setLocalPartnerId(String localPartnerId) {
        this.localPartnerId = localPartnerId;
        return this;
    }

    public String getLocalPartnerDisplayName() {
        return this.localPartnerDisplayName;
    }

    public AgreementListItemDto setLocalPartnerDisplayName(String localPartnerDisplayName) {
        this.localPartnerDisplayName = localPartnerDisplayName;
        return this;
    }

    public String getLocalPartnerBackendId() {
        return this.localPartnerBackendId;
    }

    public AgreementListItemDto setLocalPartnerBackendId(String localPartnerBackendId) {
        this.localPartnerBackendId = localPartnerBackendId;
        return this;
    }

    public String getRemotePartnerId() {
        return this.remotePartnerId;
    }

    public AgreementListItemDto setRemotePartnerId(String remotePartnerId) {
        this.remotePartnerId = remotePartnerId;
        return this;
    }

    public String getRemotePartnerDisplayName() {
        return this.remotePartnerDisplayName;
    }

    public AgreementListItemDto setRemotePartnerDisplayName(String remotePartnerDisplayName) {
        this.remotePartnerDisplayName = remotePartnerDisplayName;
        return this;
    }

    public String getRemotePartnerBackendId() {
        return this.remotePartnerBackendId;
    }

    public AgreementListItemDto setRemotePartnerBackendId(String remotePartnerBackendId) {
        this.remotePartnerBackendId = remotePartnerBackendId;
        return this;
    }

    public String getAdapterId() {
        return this.adapterId;
    }

    public AgreementListItemDto setAdapterId(String adapterId) {
        this.adapterId = adapterId;
        return this;
    }

    public String getPackagerName() {
        return this.packagerName;
    }

    public AgreementListItemDto setPackagerName(String packagerName) {
        this.packagerName = packagerName;
        return this;
    }

    public OffsetDateTime getLastModified() {
        return this.lastModified;
    }

    public AgreementListItemDto setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified;
        return this;
    }
}

