/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.cpa;

import com.fasterxml.jackson.annotation.JsonInclude;
import de.ponton.xmlpipe.rest.cpa.communication.CommunicationDto;
import de.ponton.xmlpipe.rest.cpa.integration.IntegrationDto;
import de.ponton.xmlpipe.rest.cpa.packaging.IPackagingDto;
import de.ponton.xmlpipe.rest.cpa.processing.ProcessingDto;
import de.ponton.xmlpipe.rest.cpa.validation.PartnerCertificateConstraint;
import de.ponton.xmlpipe.rest.cpp.validation.MessageTypeConstraint;
import de.ponton.xmlpipe.rest.cpp.validation.PartnerExistenceConstraint;
import de.ponton.xmlpipe.rest.cpp.validation.PartnerType;
import de.ponton.xmlpipe.rest.cpp.validation.PartnerTypeConstraint;
import de.ponton.xmlpipe.rest.jackson.TrimmedField;
import de.ponton.xmlpipe.rest.validation.Immutable;
import de.ponton.xmlpipe.rest.validation.PartnerAccessConstraint;
import de.ponton.xmlpipe.rest.validation.ValidationGroup;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Null;
import java.util.List;
import org.springframework.validation.annotation.Validated;

@Validated
@PartnerCertificateConstraint(groups={ValidationGroup.Update.class, ValidationGroup.Create.class})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Schema(description="An Agreement defines the communication between two partners.", name="Agreement")
public class AgreementDto {
    @Null(groups={ValidationGroup.Create.class})
    @NotBlank.List(value={@NotBlank(groups={ValidationGroup.Read.class}), @NotBlank(groups={ValidationGroup.Update.class})})
    @Immutable
    @Schema(description="The id of the Agreement")
    @TrimmedField
    private @Null(groups={ValidationGroup.Create.class}) @NotBlank.List(value={@NotBlank(groups={ValidationGroup.Read.class}), @NotBlank(groups={ValidationGroup.Update.class})}) String id;
    @NotBlank
    @Schema(description="The id of the template that is used to create the default values for this Agreement. The list of valid ids can be obtained from /agreements/templateids")
    @TrimmedField
    private String templateId;
    @NotBlank
    @PartnerExistenceConstraint
    @PartnerTypeConstraint(value=PartnerType.LOCAL)
    @Schema(description="The id of the own partner")
    @Immutable
    @TrimmedField
    @PartnerAccessConstraint
    private String ownPartnerId;
    @NotBlank
    @PartnerExistenceConstraint
    @PartnerTypeConstraint(value=PartnerType.LOCAL_OR_REMOTE)
    @Immutable
    @Schema(description="The id of the communication partner")
    @TrimmedField
    private String communicationPartnerId;
    @NotEmpty
    @MessageTypeConstraint
    @Schema(description="The list of message type ids that can be send and received with this agreement. The list of known ids can be obtained from /messagetype")
    private List<String> messageTypeIds;
    @Valid
    @NotNull
    private IntegrationDto integration;
    @Valid
    @NotNull
    private CommunicationDto communication;
    @Valid
    @NotNull
    private IPackagingDto packager;
    @Valid
    @NotNull
    private ProcessingDto processing;

    public String getId() {
        return this.id;
    }

    public AgreementDto setId(String id) {
        this.id = id;
        return this;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public AgreementDto setTemplateId(String templateId) {
        this.templateId = templateId;
        return this;
    }

    public String getOwnPartnerId() {
        return this.ownPartnerId;
    }

    public AgreementDto setOwnPartnerId(String ownPartnerId) {
        this.ownPartnerId = ownPartnerId;
        return this;
    }

    public String getCommunicationPartnerId() {
        return this.communicationPartnerId;
    }

    public AgreementDto setCommunicationPartnerId(String communicationPartnerId) {
        this.communicationPartnerId = communicationPartnerId;
        return this;
    }

    public List<String> getMessageTypeIds() {
        return this.messageTypeIds;
    }

    public AgreementDto setMessageTypeIds(List<String> messageTypeIds) {
        this.messageTypeIds = messageTypeIds;
        return this;
    }

    public IntegrationDto getIntegration() {
        return this.integration;
    }

    public AgreementDto setIntegration(IntegrationDto integration) {
        this.integration = integration;
        return this;
    }

    public CommunicationDto getCommunication() {
        return this.communication;
    }

    public AgreementDto setCommunication(CommunicationDto communication) {
        this.communication = communication;
        return this;
    }

    public <T extends IPackagingDto> T getPackager() {
        return (T)this.packager;
    }

    public AgreementDto setPackager(IPackagingDto packager) {
        this.packager = packager;
        return this;
    }

    public ProcessingDto getProcessing() {
        return this.processing;
    }

    public AgreementDto setProcessing(ProcessingDto processing) {
        this.processing = processing;
        return this;
    }
}

