/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.certificate;

import de.ponton.xmlpipe.rest.DtoFactoryException;
import de.ponton.xmlpipe.rest.IDtoFactory;
import de.ponton.xmlpipe.rest.certificate.CertificateDto;
import de.ponton.xmlpipe.rest.certificate.ExtendedKeyUsage;
import de.ponton.xmlpipe.rest.certificate.KeyUsage;
import de.ponton.xmlpipe.rest.certificate.SanType;
import de.ponton.xmlpipe.rest.certificate.SubjectAlternativeNameDto;
import de.pontonconsulting.xmlpipe.security.CertificateReader;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.springframework.stereotype.Component;

@Component
public class CertificateDtoFactory
implements IDtoFactory<CertificateDto, X509Certificate> {
    private final CertificateUtility certificateUtility;
    private final CertificateReader certificateReader;

    public CertificateDtoFactory(CertificateUtility certificateUtility, CertificateReader certificateReader) {
        this.certificateUtility = certificateUtility;
        this.certificateReader = certificateReader;
    }

    @Override
    public CertificateDto create(X509Certificate certificate) {
        try {
            return new CertificateDto().setCertificate(this.certificateReader.certificateBase64Encoded(certificate)).setIssuer(this.certificateUtility.getIssuer(certificate)).setKeyAlgorithm(this.certificateUtility.getKeyAlgorithmInfo(certificate)).setSerialNumber(this.certificateUtility.getSerialNumber(certificate)).setSubject(this.certificateUtility.getSubject(certificate)).setSubjectAlternativeNames(this.getSubjectAlternativeNames(certificate)).setKeyUsages(this.getKeyUsages(certificate)).setExtendedKeyUsages(this.getExtendedKeyUsages(certificate)).setValidFrom(this.certificateUtility.getValidFrom(certificate)).setValidTo(this.certificateUtility.getValidTo(certificate));
        }
        catch (CertificateEncodingException e) {
            throw new DtoFactoryException("Wrong encoding of certificate!", e);
        }
        catch (CertificateParsingException e) {
            throw new DtoFactoryException("Could not parse certificate.", e);
        }
    }

    public List<SubjectAlternativeNameDto> getSubjectAlternativeNames(X509Certificate certificate) throws CertificateParsingException {
        ArrayList<SubjectAlternativeNameDto> result = new ArrayList<SubjectAlternativeNameDto>();
        Collection<List<?>> subjectAlternativeNames = certificate.getSubjectAlternativeNames();
        if (subjectAlternativeNames != null) {
            subjectAlternativeNames.forEach(san -> {
                if (san.size() == 2) {
                    switch ((Integer)san.getFirst()) {
                        case 1: {
                            result.add(new SubjectAlternativeNameDto().setType(SanType.EMAIL).setValue((String)san.getLast()));
                            break;
                        }
                        case 2: {
                            result.add(new SubjectAlternativeNameDto().setType(SanType.DNS).setValue((String)san.getLast()));
                            break;
                        }
                        case 6: {
                            result.add(new SubjectAlternativeNameDto().setType(SanType.URI).setValue((String)san.getLast()));
                            break;
                        }
                        case 7: {
                            result.add(new SubjectAlternativeNameDto().setType(SanType.IP).setValue((String)san.getLast()));
                            break;
                        }
                    }
                }
            });
        }
        return result;
    }

    public List<KeyUsage> getKeyUsages(X509Certificate certificate) {
        ArrayList<KeyUsage> result = new ArrayList<KeyUsage>();
        boolean[] keyUsageFlags = certificate.getKeyUsage();
        if (keyUsageFlags != null) {
            if (keyUsageFlags[0]) {
                result.add(KeyUsage.DIGITAL_SIGNATURE);
            }
            if (keyUsageFlags[1]) {
                result.add(KeyUsage.NON_REPUDIATION);
            }
            if (keyUsageFlags[2]) {
                result.add(KeyUsage.KEY_ENCIPHERMENT);
            }
            if (keyUsageFlags[3]) {
                result.add(KeyUsage.DATA_ENCIPHERMENT);
            }
            if (keyUsageFlags[4]) {
                result.add(KeyUsage.KEY_AGREEMENT);
            }
            if (keyUsageFlags[5]) {
                result.add(KeyUsage.KEY_CERT_SIGN);
            }
            if (keyUsageFlags[6]) {
                result.add(KeyUsage.C_RL_SIGN);
            }
            if (keyUsageFlags[7]) {
                result.add(KeyUsage.ENCIPHER_ONLY);
            }
            if (keyUsageFlags[8]) {
                result.add(KeyUsage.DECIPHER_ONLY);
            }
        }
        result.sort(Comparator.comparing(Enum::name));
        return result;
    }

    public List<ExtendedKeyUsage> getExtendedKeyUsages(X509Certificate certificate) throws CertificateParsingException {
        ArrayList<ExtendedKeyUsage> result = new ArrayList<ExtendedKeyUsage>();
        List<String> extendedKeyUsage = certificate.getExtendedKeyUsage();
        if (extendedKeyUsage != null) {
            if (extendedKeyUsage.contains(KeyPurposeId.id_kp_serverAuth.getId())) {
                result.add(ExtendedKeyUsage.SERVER_AUTH);
            }
            if (extendedKeyUsage.contains(KeyPurposeId.id_kp_clientAuth.getId())) {
                result.add(ExtendedKeyUsage.CLIENT_AUTH);
            }
            if (extendedKeyUsage.contains(KeyPurposeId.id_kp_codeSigning.getId())) {
                result.add(ExtendedKeyUsage.CODE_SIGNING);
            }
            if (extendedKeyUsage.contains(KeyPurposeId.id_kp_emailProtection.getId())) {
                result.add(ExtendedKeyUsage.EMAIL_PROTECTION);
            }
            if (extendedKeyUsage.contains(KeyPurposeId.id_kp_timeStamping.getId())) {
                result.add(ExtendedKeyUsage.TIME_STAMPING);
            }
            if (extendedKeyUsage.contains(KeyPurposeId.id_kp_OCSPSigning.getId())) {
                result.add(ExtendedKeyUsage.OCSP_SIGNING);
            }
            if (extendedKeyUsage.contains(KeyPurposeId.id_kp_ipsecIKE.getId())) {
                result.add(ExtendedKeyUsage.IPSEC_IKE);
            }
        }
        result.sort(Comparator.comparing(Enum::name));
        return result;
    }

    @Override
    public X509Certificate parse(CertificateDto certificateDto) {
        return this.parse(certificateDto.getCertificate());
    }

    @Override
    public X509Certificate parse(String certificate) {
        try {
            return this.certificateUtility.getX509Certificate(certificate);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

