/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.authorization;

import de.ponton.xmlpipe.rest.RequestUtils;
import de.ponton.xmlpipe.rest.authorization.UserRoleDto;
import de.ponton.xmlpipe.rest.authorization.UserRoleDtoFactory;
import de.ponton.xmlpipe.rest.validation.ValidationGroup;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.UserRole;
import de.pontonconsulting.xmlpipe.security.acegi.UserRoleService;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.validation.Valid;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/userRoles"})
@Validated
public class UserRoleController
implements ApplicationContextAware,
InitializingBean {
    private final UserRoleDtoFactory userRoleDtoFactory;
    private static final Logger AUDIT = LogManager.getLogger((String)("Audit." + UserRoleController.class.getName()));
    private final UserRoleService userRoleService;
    private final Set<String> permissions = new TreeSet<String>();
    private ApplicationContext applicationContext;

    public UserRoleController(UserRoleDtoFactory userRoleDtoFactory, UserRoleService userRoleService) {
        this.userRoleDtoFactory = userRoleDtoFactory;
        this.userRoleService = userRoleService;
    }

    @GetMapping
    @Operation(summary="Show all the available roles", description="permission:USER_ROLES_GET<br><br>A list of available roles is returned.", tags={"User Security Settings"})
    @Secured(value={"USER_ROLES_GET"})
    public ResponseEntity<List<UserRoleDto>> getRoles() {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body(this.userRoleService.getUserRoles().stream().map(this.userRoleDtoFactory::create).collect(Collectors.toList()));
    }

    @GetMapping(value={"/permissions"})
    @Secured(value={"USER_ROLES_PERMISSIONS_GET"})
    @Operation(summary="Get the permissions assigned to the respective roles", description="permission:USER_ROLES_PERMISSIONS_GET<br><br>A list of permissions assigned to each role is returned.", tags={"User Security Settings"})
    public ResponseEntity<List<String>> getPermissions() {
        TreeSet<String> list = new TreeSet<String>(this.permissions.stream().toList());
        list.addAll(List.of("HTTP_ADAPTER_OUTBOUND_POST", "HTTP_ADAPTER_INBOUND_GET", "HTTP_ADAPTER_ACK_GET"));
        list.addAll(this.userRoleService.getUserRoles().stream().map(UserRole::getId).toList());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body(list.stream().toList());
    }

    @GetMapping(value={"/systemRoles"})
    @Secured(value={"USER_ROLES_SYSTEM_ROLES_GET"})
    @Operation(summary="Get the System Roles", description="permission:USER_ROLES_SYSTEM_ROLES_GET<br><br>A list of the System Roles.", tags={"User Security Settings"})
    public ResponseEntity<List<String>> getSystemRoles() {
        return ResponseEntity.ok(this.userRoleService.getSystemRoles());
    }

    @GetMapping(value={"/{id}"})
    @Operation(summary="Show a specific role", description="permission:USER_ROLES_GET<br><br>Show a specific role.", tags={"User Security Settings"})
    @Secured(value={"USER_ROLES_GET"})
    public ResponseEntity<UserRoleDto> editRole(@PathVariable String id) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)this.userRoleDtoFactory.create(this.userRoleService.getUserRole(id)));
    }

    @PostMapping
    @Validated(value={ValidationGroup.Create.class})
    @Secured(value={"USER_ROLES_POST"})
    @Operation(summary="Create a new role", description="permission:USER_ROLES_POST<br><br>Create a new role.", tags={"User Security Settings"})
    public ResponseEntity<UserRoleDto> createRole(@RequestBody @Valid UserRoleDto userRole, Principal principal) throws IOException {
        this.userRoleService.addUserRole(this.userRoleDtoFactory.parse(userRole).setSystemRole(false), principal.getName());
        AUDIT.info("{'{}', '{}' -> '{}'} User Role '{}' created with permissions '{}'.", (Object)principal.getName(), (Object)RequestUtils.getRemoteAddress(), (Object)RequestUtils.getLocalAddress(), (Object)userRole.getId(), userRole.getPermissions());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)userRole);
    }

    @PutMapping(value={"/{id}"})
    @Operation(summary="Modify an existing role", description="permission:USER_ROLES_PUT<br><br>Modify an existing role.", tags={"User Security Settings"})
    @Secured(value={"USER_ROLES_PUT"})
    public ResponseEntity<Void> editRole(@PathVariable String id, @Valid @RequestBody UserRoleDto userRole, Principal principal) throws IOException {
        if (this.userRoleService.getSystemRoles().contains(id)) {
            throw new IllegalArgumentException("Cannot modify " + id + " role");
        }
        List currentPermissions = this.userRoleService.getUserRole(id).getPermissions().stream().toList();
        List<String> newPermissions = userRole.getPermissions();
        ArrayList<String> addedPermissions = new ArrayList<String>(newPermissions);
        addedPermissions.removeAll(currentPermissions);
        ArrayList removedPermissions = new ArrayList(currentPermissions);
        removedPermissions.removeAll(newPermissions);
        this.userRoleService.editUserRole(id, this.userRoleDtoFactory.parse(userRole).setSystemRole(false), principal.getName());
        AUDIT.info("{'{}', '{}' -> '{}'} Modified User Role '{}'. Permissions Added:'{}', Permissions Removed:'{}', Current Permissions:'{}'.", (Object)principal.getName(), (Object)RequestUtils.getRemoteAddress(), (Object)RequestUtils.getLocalAddress(), (Object)userRole.getId(), addedPermissions, removedPermissions, userRole.getPermissions());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NO_CONTENT).build();
    }

    @DeleteMapping(value={"/{id}"})
    @Operation(summary="Delete an existing role", description="permission:USER_ROLES_DELETE<br><br>Delete an existing role.", tags={"User Security Settings"})
    @Secured(value={"USER_ROLES_DELETE"})
    public ResponseEntity<Void> deleteRole(@PathVariable String id, Principal principal) throws IOException {
        if (this.userRoleService.getSystemRoles().contains(id)) {
            throw new IllegalArgumentException("Cannot delete " + id + " role");
        }
        this.userRoleService.deleteUserRole(id, principal.getName());
        AUDIT.info("{'{}', '{}' -> '{}'} Deleted User Role '{}'.", (Object)principal.getName(), (Object)RequestUtils.getRemoteAddress(), (Object)RequestUtils.getLocalAddress(), (Object)id);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NO_CONTENT).build();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        this.extractRestControllerPermissions();
    }

    private void extractRestControllerPermissions() {
        String[] beanNamesForAnnotation = this.applicationContext.getBeanNamesForAnnotation(RestController.class);
        Arrays.stream(beanNamesForAnnotation).forEach(name -> this.permissions.addAll(this.applicationContext.findAllAnnotationsOnBean(name, Secured.class, false).stream().flatMap(e -> Arrays.stream(e.value())).toList()));
        Arrays.stream(beanNamesForAnnotation).forEach(name -> Arrays.stream(Objects.requireNonNull(this.applicationContext.getType(name, false)).getDeclaredMethods()).filter(method -> AnnotationUtils.findAnnotation((Method)method, Secured.class) != null).flatMap(method -> Arrays.stream(Objects.requireNonNull((Secured)AnnotationUtils.findAnnotation((Method)method, Secured.class)).value())).forEach(this.permissions::add));
    }
}

