/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.authorization;

import de.ponton.xmlpipe.rest.authorization.ClientRoleDto;
import de.ponton.xmlpipe.rest.authorization.ClientRoleDtoFactory;
import de.pontonconsulting.xmlpipe.security.acegi.ClientRoleService;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.validation.Valid;
import java.io.IOException;
import java.security.Principal;
import java.util.List;
import java.util.stream.Collectors;
import org.hibernate.validator.constraints.UniqueElements;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/clientRoles"})
@Validated
public class ClientRoleController {
    private final ClientRoleDtoFactory clientRoleDtoFactory;
    private final ClientRoleService clientRoleService;
    public static final String DOCUMENTATION_TAG = "Client Roles";

    public ClientRoleController(ClientRoleDtoFactory clientRoleDtoFactory, ClientRoleService clientRoleService) {
        this.clientRoleDtoFactory = clientRoleDtoFactory;
        this.clientRoleService = clientRoleService;
    }

    @GetMapping
    @Operation(summary="Show all the available roles", description="permission:CLIENT_ROLES_GET<br><br>A list of available roles is returned.", tags={"Client Roles"})
    @Secured(value={"CLIENT_ROLES_GET"})
    public ResponseEntity<List<ClientRoleDto>> getRoles() {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body(this.clientRoleService.getClientRoles().stream().map(this.clientRoleDtoFactory::create).collect(Collectors.toList()));
    }

    @PutMapping
    @Operation(summary="Modify all client roles", description="permission:CLIENT_ROLES_PUT<br><br>Modify all existing roles.", tags={"Client Roles"})
    @Secured(value={"CLIENT_ROLES_PUT"})
    public ResponseEntity<Void> editRole(@Valid @RequestBody @UniqueElements List<ClientRoleDto> clientRoles, Principal principal) throws IOException {
        this.clientRoleService.saveRoles(clientRoles.stream().map(this.clientRoleDtoFactory::parse).toList(), principal.getName());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NO_CONTENT).build();
    }
}

