/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.adapter;

import de.ponton.xmlpipe.rest.adapter.AdapterInfoService;
import de.ponton.xmlpipe.rest.adapter.NotInternalAdapterConstraint;
import de.ponton.xmlpipe.rest.exception.ResourceNotFoundException;
import de.pontonconsulting.xmlpipe.adapter.AdapterInfo;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.constraintvalidation.SupportedValidationTarget;
import jakarta.validation.constraintvalidation.ValidationTarget;

@SupportedValidationTarget(value={ValidationTarget.ANNOTATED_ELEMENT})
public class NotInternalAdapterValidator
implements ConstraintValidator<NotInternalAdapterConstraint, String> {
    private final AdapterInfoService adapterInfoService;

    public NotInternalAdapterValidator(AdapterInfoService adapterInfoService) {
        this.adapterInfoService = adapterInfoService;
    }

    public boolean isValid(String adapterId, ConstraintValidatorContext context) {
        if (adapterId == null) {
            return true;
        }
        try {
            AdapterInfo adapter = this.adapterInfoService.getAdapter(adapterId);
            return !"INTERNAL".equals(adapter.getAddress());
        }
        catch (ResourceNotFoundException e) {
            return true;
        }
    }
}

