/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.activation;

import de.pontonconsulting.activation.ActivationException;
import de.pontonconsulting.security.CertificateCreator;
import de.pontonconsulting.util.CommonFormat;
import de.pontonconsulting.xmlpipe.activation.MessengerActivation;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class MessengerLicenseService {
    private final MessengerActivation messengerActivationManager;

    public MessengerLicenseService(MessengerActivation messengerActivationManager) {
        this.messengerActivationManager = messengerActivationManager;
    }

    public void installLicense(String licenseCertificateString) throws ActivationException {
        if (this.isValidLicense(licenseCertificateString)) {
            try {
                X509Certificate licence = CertificateCreator.getCertificate((byte[])CommonFormat.decodeBase64((String)"-----BEGIN LICENSE-----\n", (String)licenseCertificateString, (String)"\n-----END LICENSE-----\n"));
                this.messengerActivationManager.importLicense(licence);
            }
            catch (GeneralSecurityException e) {
                throw new ActivationException(1021L, "Unable to read license", (Throwable)e);
            }
        }
    }

    public boolean isValidLicense(String license) {
        if (StringUtils.isNotBlank((CharSequence)license)) {
            return license.trim().startsWith("-----BEGIN LICENSE-----\n".trim()) && license.trim().endsWith("\n-----END LICENSE-----\n".trim());
        }
        return false;
    }
}

