/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.activation;

import de.ponton.xmlpipe.rest.activation.ActivationFactory;
import de.ponton.xmlpipe.rest.activation.ActivationOrLicenseDto;
import de.ponton.xmlpipe.rest.activation.MessengerActivationDto;
import de.pontonconsulting.activation.ActivationException;
import de.pontonconsulting.activation.ActivationRequest;
import de.pontonconsulting.activation.IProductStateChecker;
import de.pontonconsulting.activation.IRequestExtensionBuilder;
import de.pontonconsulting.activation.util.ActivationRequestUtil;
import de.pontonconsulting.xmlpipe.activation.ActivationControl;
import de.pontonconsulting.xmlpipe.activation.MessengerActivation;
import java.security.PrivateKey;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class MessengerActivationService {
    private final MessengerActivation messengerActivationManager;
    private final IProductStateChecker productStateChecker;
    private final IRequestExtensionBuilder requestExtensionBuilder;
    private final ActivationFactory activationFactory;
    private final ActivationControl activationControl;

    public MessengerActivationService(MessengerActivation messengerActivationManager, IProductStateChecker productStateChecker, IRequestExtensionBuilder requestExtensionBuilder, ActivationFactory activationFactory, ActivationControl activationControl) {
        this.messengerActivationManager = messengerActivationManager;
        this.productStateChecker = productStateChecker;
        this.requestExtensionBuilder = requestExtensionBuilder;
        this.activationFactory = activationFactory;
        this.activationControl = activationControl;
    }

    public MessengerActivationDto getMessengerActivation() throws ActivationException {
        return new MessengerActivationDto().setLicenseName(this.messengerActivationManager.getCompanyName()).setTrial(this.messengerActivationManager.isTrialVersion()).setActivated(this.activationControl.isActive()).setDaysLeft(this.activationControl.isActive() ? this.messengerActivationManager.getDaysLeft() : -1L).setGracePeriod(this.messengerActivationManager.calculateGracePeriod()).setCluster(this.messengerActivationManager.isClusterModeEnabled()).setEbxml2(this.messengerActivationManager.isEbXML2MessagingEnabled()).setAs123(this.messengerActivationManager.isASxMessagingEnabled()).setAs4(this.messengerActivationManager.isAS4MessagingEnabled()).setAs4EC(this.messengerActivationManager.isAS4EllipticCurveEnabled()).setPlain(this.messengerActivationManager.isPlainMessagingEnabled()).setMaximumLocalPartners(this.messengerActivationManager.getLocalProfilesMaxSize()).setMaximumRemotePartners(this.messengerActivationManager.getRemoteProfilesMaxSize()).setLicenseSerialNumber(this.messengerActivationManager.getLicenseSerialNumber());
    }

    public void installActivation(String activationCertificateString) throws ActivationException {
        if (this.isValidActivation(activationCertificateString)) {
            PrivateKey key = this.messengerActivationManager.getProductIdentification().getPrivateKey();
            this.messengerActivationManager.importActivation(this.productStateChecker, this.activationFactory.createActivation(activationCertificateString, key));
        }
    }

    public boolean isValidActivation(String activation) {
        if (StringUtils.isNotBlank((CharSequence)activation)) {
            return activation.trim().startsWith("-----BEGIN ACTIVATION-----\n".trim()) && activation.trim().endsWith("\n-----END ACTIVATION-----\n".trim());
        }
        return false;
    }

    public ActivationOrLicenseDto updateActivationRequest() throws ActivationException {
        return new ActivationOrLicenseDto().setData(ActivationRequestUtil.encodeBase64((byte[])ActivationRequestUtil.encryptActivationRequest((ActivationRequest)this.messengerActivationManager.generateActivationRequest(this.requestExtensionBuilder))));
    }
}

