/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.queue;

import de.pontonconsulting.xmlpipe.cpa.AgreementException;
import de.pontonconsulting.xmlpipe.cpa.Agreements;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.XpBaseMessage;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.XpInboundMessage;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.XpOutboundMessage;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageWorkDataDAO;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XpMessageLoader {
    private final Logger log = LogManager.getLogger((String)"Messenger.XpMessageLoader");
    private final Agreements agreements;
    private final Profiles profiles;
    private final MessageDAO messageDAO;
    private final MessageWorkDataDAO messageWorkDataDAO;

    public XpMessageLoader(Agreements agreements, Profiles profiles, MessageDAO messageDAO, MessageWorkDataDAO messageWorkDataDAO) {
        this.agreements = agreements;
        this.profiles = profiles;
        this.messageDAO = messageDAO;
        this.messageWorkDataDAO = messageWorkDataDAO;
    }

    public XpInboundMessage loadInboundMessage(long messageDbId) {
        return (XpInboundMessage)this.loadMessage(messageDbId, true);
    }

    public XpOutboundMessage loadOutboundMessage(long messageDbId) {
        return (XpOutboundMessage)this.loadMessage(messageDbId, false);
    }

    private XpBaseMessage loadMessage(long messageDbId, boolean inbound) {
        this.log.info("Load XpMessage from Database");
        try {
            Optional<XpBaseMessage> xpMsg = this.loadXpQueueMessage(messageDbId, inbound);
            if (xpMsg.isPresent()) {
                XpBaseMessage xpQueueMessage = xpMsg.get();
                this.prepareXpMessage(xpQueueMessage);
                int restoreCount = this.messageWorkDataDAO.restoreDirectoryFromDB(messageDbId, xpQueueMessage.getCurrentContentReferenceFolder());
                if (restoreCount < 0) {
                    this.log.error("Can't restore MessageWorkFolder from database");
                    return null;
                }
                return xpQueueMessage;
            }
            this.log.error("Could not find XpMessage to load in database");
        }
        catch (Exception e) {
            this.log.error("{} while restoring XpMessage: {}", (Object)e.getClass().getName(), (Object)e.getMessage());
            this.log.debug(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private void prepareXpMessage(XpBaseMessage xpQueueMessage) {
        if (xpQueueMessage instanceof XpOutboundMessage) {
            XpOutboundMessage xpOutboundMessage = (XpOutboundMessage)xpQueueMessage;
            this.setAgreementAndReturnCommunicationPartnerId(xpOutboundMessage);
        }
    }

    private Optional<XpBaseMessage> loadXpQueueMessage(long messageDbId, boolean inbound) throws DbException {
        if (inbound) {
            return Optional.ofNullable(this.messageDAO.loadXpInboundMessage(messageDbId));
        }
        return Optional.ofNullable(this.messageDAO.loadXpOutboundMessage(messageDbId));
    }

    private void setAgreementAndReturnCommunicationPartnerId(XpOutboundMessage xpOutboundMessage) {
        String ownPartnerId = xpOutboundMessage.getSenderLocalId();
        String communicationPartnerId = xpOutboundMessage.getReceiverLocalId();
        try {
            xpOutboundMessage.setAgreement(this.agreements.getAgreement(ownPartnerId, communicationPartnerId, true), communicationPartnerId);
        }
        catch (AgreementException e) {
            try {
                communicationPartnerId = this.profiles.getProfileForInternalId(xpOutboundMessage.getReceiverInternalId(), true).getLocalId();
                xpOutboundMessage.setAgreement(this.agreements.getAgreement(ownPartnerId, communicationPartnerId, true), communicationPartnerId);
            }
            catch (AgreementException | ProfileException e2) {
                this.log.error("{} while setting agreement to XpOutboundQueueMessage ({}): {}", (Object)e2.getClass().getSimpleName(), (Object)xpOutboundMessage.getMessageId(), (Object)e2.getMessage());
            }
        }
    }

    public XpBaseMessage saveXpMessage(XpMessage xpMessage) throws DbException {
        return this.messageDAO.saveXpMessage(xpMessage);
    }
}

