/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.queue;

import de.ponton.xmlpipe.queue.EndpointQueue;
import de.ponton.xmlpipe.queue.IEndpointQueueFactory;
import de.ponton.xmlpipe.queue.IQueueMessage;
import de.ponton.xmlpipe.queue.QueueMessageConsumer;
import jakarta.annotation.Nullable;
import jakarta.persistence.EntityManager;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MultipleQueue {
    private final Logger log = LogManager.getLogger((String)("Messenger." + this.getClass().getSimpleName()));
    private final IEndpointQueueFactory endpointQueueFactory;
    private final Map<String, EndpointQueue> lookup;
    private final Queue<EndpointQueue> endpointQueues;
    private final Set<QueueMessageConsumer> listeners;
    private final ScheduledExecutorService scheduler;
    private ScheduledFuture<?> syncQueueTask;
    private final ReadWriteLock rwLockForKeyStore = new ReentrantReadWriteLock(true);
    private final Lock readLock = this.rwLockForKeyStore.readLock();
    private final Lock writeLock = this.rwLockForKeyStore.writeLock();

    public MultipleQueue(IEndpointQueueFactory endpointQueueFactory) {
        this.endpointQueueFactory = endpointQueueFactory;
        this.lookup = new ConcurrentHashMap<String, EndpointQueue>();
        this.endpointQueues = new ConcurrentLinkedQueue<EndpointQueue>();
        this.listeners = new HashSet<QueueMessageConsumer>();
        this.scheduler = Executors.newScheduledThreadPool(1);
    }

    public synchronized void startSyncQueueTask() {
        if (this.syncQueueTask == null) {
            this.syncQueueTask = this.scheduler.scheduleAtFixedRate(this::synchronizeQueues, 0L, 30L, TimeUnit.SECONDS);
        }
    }

    public void shutdown() {
        if (this.syncQueueTask != null) {
            this.syncQueueTask.cancel(true);
        }
        this.scheduler.shutdown();
    }

    public int size() {
        AtomicInteger size = new AtomicInteger(0);
        List.copyOf(this.lookup.values()).forEach(endpointQueue -> size.addAndGet(endpointQueue.size()));
        this.log.trace("Queue size: {}", (Object)size.get());
        return size.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(IQueueMessage queueMessage) {
        EndpointQueue tempEndpointQueue;
        String endpoint = queueMessage.getEndpoint();
        this.readLock.lock();
        try {
            tempEndpointQueue = this.lookup.get(endpoint);
        }
        finally {
            this.readLock.unlock();
        }
        if (tempEndpointQueue == null) {
            this.writeLock.lock();
            try {
                tempEndpointQueue = this.lookup.get(endpoint);
                if (tempEndpointQueue == null) {
                    tempEndpointQueue = this.endpointQueueFactory.createEndpointQueue(endpoint);
                    this.lookup.put(endpoint, tempEndpointQueue);
                    this.endpointQueues.add(tempEndpointQueue);
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
        EndpointQueue endpointQueue = tempEndpointQueue;
        endpointQueue.updateTimeOfLastAddedMessage();
        boolean result = endpointQueue.offer(queueMessage);
        this.notifyListeners();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureEndpointQueuesAreRegistered(List<String> endpoints) {
        this.writeLock.lock();
        try {
            boolean newEndpointQueueAdded = false;
            for (String endpoint : endpoints) {
                EndpointQueue endpointQueue = this.lookup.get(endpoint);
                if (endpointQueue != null) continue;
                endpointQueue = this.endpointQueueFactory.createEndpointQueue(endpoint);
                this.lookup.put(endpoint, endpointQueue);
                this.endpointQueues.add(endpointQueue);
                newEndpointQueueAdded = true;
                this.log.info("Registered new endpoint queue: {}", (Object)endpoint);
            }
            if (newEndpointQueueAdded) {
                this.notifyListeners();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners() {
        Set<QueueMessageConsumer> set = this.listeners;
        synchronized (set) {
            this.listeners.forEach(QueueMessageConsumer::wakeUp);
        }
    }

    public Optional<IQueueMessage> getNextMessage() {
        for (int i = this.endpointQueues.size(); i > 0; --i) {
            Optional<EndpointQueue> endpointQueue;
            this.readLock.lock();
            try {
                endpointQueue = Optional.ofNullable(this.endpointQueues.poll());
                endpointQueue.ifPresent(this.endpointQueues::offer);
            }
            finally {
                this.readLock.unlock();
            }
            if (endpointQueue.isPresent()) {
                Optional<IQueueMessage> message = endpointQueue.get().nextMessage();
                if (!message.isPresent()) continue;
                return message;
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void synchronizeQueues() {
        this.log.debug("Start synchronize InboundQueues");
        List<String> endpointsWithPendingMessages = this.endpointQueueFactory.getAllEndpointsFromQueuedMessages();
        this.log.trace("Found {} endpoints with pending messages", (Object)endpointsWithPendingMessages.size());
        for (EndpointQueue endpointQueue : List.copyOf(this.lookup.values())) {
            if (endpointsWithPendingMessages.remove(endpointQueue.getEndpoint())) continue;
            this.writeLock.lock();
            try {
                if (!endpointQueue.canBeDeleted()) continue;
                this.endpointQueues.remove(endpointQueue);
                this.lookup.remove(endpointQueue.getEndpoint());
                this.log.trace("Removed empty EndpointQueue {}", (Object)endpointQueue.getEndpoint());
            }
            finally {
                this.writeLock.unlock();
            }
        }
        if (!endpointsWithPendingMessages.isEmpty()) {
            this.log.trace("Found {} new (not yet registered) endpoints with pending messages", (Object)endpointsWithPendingMessages.size());
            this.ensureEndpointQueuesAreRegistered(endpointsWithPendingMessages);
        }
    }

    public boolean remove(IQueueMessage queueMessage) {
        Optional<EndpointQueue> endpointQueue = Optional.ofNullable(this.lookup.get(queueMessage.getEndpoint()));
        boolean deleted = endpointQueue.map(queue -> queue.remove(queueMessage)).orElse(false);
        if (deleted) {
            this.notifyListeners();
        }
        return deleted;
    }

    public Optional<IQueueMessage> remove(long messageUniqueId, @Nullable String endpointId) {
        EndpointQueue endpointQueue;
        EndpointQueue endpointQueue2 = endpointQueue = endpointId != null ? this.lookup.get(endpointId) : null;
        if (endpointQueue != null) {
            Optional<IQueueMessage> queueMessage = endpointQueue.removeById(messageUniqueId, null);
            if (queueMessage.isPresent()) {
                this.notifyListeners();
            }
            return queueMessage;
        }
        return this.remove(messageUniqueId);
    }

    public Optional<IQueueMessage> remove(long messageUniqueId) {
        for (EndpointQueue endpointQueue : List.copyOf(this.lookup.values())) {
            Optional<IQueueMessage> removedQueueMessage = endpointQueue.removeById(messageUniqueId);
            if (!removedQueueMessage.isPresent()) continue;
            this.notifyListeners();
            return removedQueueMessage;
        }
        return Optional.empty();
    }

    public Optional<IQueueMessage> remove(long messageUniqueId, EntityManager entityManager) {
        for (EndpointQueue endpointQueue : List.copyOf(this.lookup.values())) {
            Optional<IQueueMessage> removedQueueMessage = endpointQueue.removeById(messageUniqueId, entityManager);
            if (!removedQueueMessage.isPresent()) continue;
            this.notifyListeners();
            return removedQueueMessage;
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListener(QueueMessageConsumer queueMessageConsumer) {
        Set<QueueMessageConsumer> set = this.listeners;
        synchronized (set) {
            this.listeners.add(queueMessageConsumer);
        }
    }
}

