/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.queue;

import de.pontonconsulting.xmlpipe.adapter.AdapterRegistry;
import de.pontonconsulting.xmlpipe.messenger.database.tables.InboundQueueingDAO;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InboundQueueTimeoutCheckTask {
    private static final Logger log = LogManager.getLogger((String)"Messenger.InboundQueueTimeoutCheckTask");
    private final AdapterRegistry adapterRegistry;
    private final InboundQueueingDAO inboundQueueingDAO;

    public InboundQueueTimeoutCheckTask(AdapterRegistry adapterRegistry, InboundQueueingDAO inboundQueueingDAO) {
        this.adapterRegistry = adapterRegistry;
        this.inboundQueueingDAO = inboundQueueingDAO;
    }

    public void run() {
        log.debug("Starting InboundQueueTimeoutCheckTask");
        for (String adapterId : this.adapterRegistry.getAdapters()) {
            log.trace("Start checking adapter {}", (Object)adapterId);
            List<Long> messageIds = this.inboundQueueingDAO.getTimedOutMessagesOfAdapter(adapterId, this.adapterRegistry.getAdapter(adapterId).getProcessingTimeout());
            for (Long messageId : messageIds) {
                log.warn("Found timed out message ({}) for adapter {} => reset transmission", (Object)messageId, (Object)adapterId);
                this.inboundQueueingDAO.resetTransmissionState(messageId);
            }
        }
        log.debug("Finished InboundQueueTimeoutCheckTask");
    }
}

