/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.queue;

import de.ponton.xmlpipe.metrics.MetricsService;
import de.ponton.xmlpipe.metrics.XPMetrics;
import de.ponton.xmlpipe.queue.InboundQueueMessage;
import de.ponton.xmlpipe.queue.MultipleQueue;
import de.ponton.xmlpipe.queue.XpMessageLoader;
import de.pontonconsulting.xmlpipe.adapter.AdapterRegistry;
import de.pontonconsulting.xmlpipe.config.IFolders;
import de.pontonconsulting.xmlpipe.config.SchemataConfig;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.InboundQueueException;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.archive.ArchiveProcessor;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.XpInboundMessage;
import de.pontonconsulting.xmlpipe.messenger.database.tables.InboundQueueingDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageWorkDataDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import java.io.File;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.FileSystemUtils;

public class InboundQueue {
    private final Logger log = LogManager.getLogger((String)("Messenger." + this.getClass().getSimpleName()));
    private final XpMessageLoader xpMessageLoader;
    private final MultipleQueue multipleQueue;
    private final InboundQueueingDAO inboundQueueingDAO;
    private final MessageDAO messageDAO;
    private final ReferenceDateTask referenceDateTask;
    private final AdapterRegistry adapterRegistry;
    private final Supplier<Long> retryInterval;
    private final MessengerLog messengerLog;
    private final ArchiveProcessor archiveProcessor;
    private final SchemataConfig schemataConfig;
    private final MessageWorkDataDAO messageWorkDataDAO;
    private final MetricsService metricsService;
    public final IFolders folders;

    public InboundQueue(XpMessageLoader xpMessageLoader, MultipleQueue multipleQueue, InboundQueueingDAO inboundQueueingDAO, MessageDAO messageDAO, ReferenceDateTask referenceDateTask, AdapterRegistry adapterRegistry, Supplier<Long> retryInterval, MessengerLog messengerLog, ArchiveProcessor archiveProcessor, SchemataConfig schemataConfig, MessageWorkDataDAO messageWorkDataDAO, MetricsService metricsService, IFolders folders) {
        this.xpMessageLoader = xpMessageLoader;
        this.multipleQueue = multipleQueue;
        this.inboundQueueingDAO = inboundQueueingDAO;
        this.messageDAO = messageDAO;
        this.referenceDateTask = referenceDateTask;
        this.adapterRegistry = adapterRegistry;
        this.retryInterval = retryInterval;
        this.messengerLog = messengerLog;
        this.archiveProcessor = archiveProcessor;
        this.schemataConfig = schemataConfig;
        this.messageWorkDataDAO = messageWorkDataDAO;
        this.metricsService = metricsService;
        this.folders = folders;
    }

    public void deliverMessageToAdapter(String adapterId, XpMessage xpMessage) throws InboundQueueException {
        try {
            this.deliverMessageToAdapter(adapterId, (XpInboundMessage)this.messageDAO.saveXpMessage(xpMessage));
        }
        catch (DbException e) {
            this.log.error("Can't update message meta data due to {}", (Object)e.toString());
            this.log.debug(e.toString(), (Throwable)e);
            throw new InboundQueueException("Can't update message meta data (" + xpMessage.getMessageId() + ") in database: " + e.getMessage());
        }
    }

    public void deliverMessageToAdapter(String adapterId, XpInboundMessage xpInboundMessage) throws InboundQueueException {
        this.log.debug("adding message mid:{} to DeliveryQueue for adapter: {}", (Object)xpInboundMessage.getMessageId(), (Object)adapterId);
        xpInboundMessage.setAdapterId(adapterId);
        this.messageDAO.updateMessageAdapterId(xpInboundMessage.getDatabaseId(), adapterId);
        try {
            this.messageWorkDataDAO.uploadDirectoryToDB(xpInboundMessage.getDatabaseId(), xpInboundMessage.getCurrentContentReferenceFolder());
            this.deleteMessageWorkFolder(xpInboundMessage.getDatabaseId());
        }
        catch (DbException e) {
            this.log.error("Can't upload message to database", (Throwable)e);
            throw new InboundQueueException("Can't upload message files to database: " + e.getMessage());
        }
        InboundQueueMessage inboundQueueMessage = new InboundQueueMessage(this.xpMessageLoader, this.adapterRegistry, this.referenceDateTask, this.schemataConfig, this.retryInterval, xpInboundMessage);
        inboundQueueMessage.setQueuedTimestamp(this.referenceDateTask.getReferenceCurrentTimeMillis());
        this.multipleQueue.offer(inboundQueueMessage);
        this.metricsService.getMeter(XPMetrics.MESSAGES_INBOUND_QUEUE_ADD_RATE).mark();
    }

    public boolean changeAdapterId(long messageDataId, String newAdapterId) throws InboundQueueException {
        Optional<InboundQueueMessage> inboundMessage = this.deleteFromInboundQueue(messageDataId);
        if (inboundMessage.isPresent()) {
            this.deliverMessageToAdapter(newAdapterId, inboundMessage.get().getXpInboundMessage());
            return true;
        }
        return false;
    }

    public void init() throws DbException {
        this.log.debug("Start initialization of InboundQueue");
        this.multipleQueue.startSyncQueueTask();
        this.inboundQueueingDAO.loadMessagesInTransferFromDatabase(dbInbound -> {
            try {
                XpInboundMessage xpInboundMessage = this.messageDAO.loadXpInboundMessage(dbInbound.getMessageId());
                if (Objects.isNull(xpInboundMessage)) {
                    throw new IllegalStateException("Could not restore XpMessage mid:" + dbInbound.getMessageId());
                }
                InboundQueueMessage inboundQueueMessage = new InboundQueueMessage(this.xpMessageLoader, this.adapterRegistry, this.referenceDateTask, this.schemataConfig, this.retryInterval, xpInboundMessage);
                inboundQueueMessage.deliveryStarted();
                inboundQueueMessage.setQueuedTimestamp(dbInbound.getTimeseconds());
                this.multipleQueue.offer(inboundQueueMessage);
            }
            catch (Exception e) {
                this.log.error("Could not reconstruct inbound message: {}", (Object)e.toString());
                try {
                    this.deleteMessageWorkFolder(dbInbound.getMessageId());
                    this.inboundQueueingDAO.deleteFromInboundQueue(dbInbound.getMessageId());
                }
                catch (DbException ex) {
                    this.log.error("Could not delete inbound message: {}", (Object)ex.getMessage());
                }
                this.archiveProcessor.sendFilesToArchive(dbInbound.getMessageId(), true);
                this.messageDAO.updateMessageStatus((long)dbInbound.getMessageId(), null, 4);
                this.messengerLog.log2db(540, dbInbound.getMessageId(), e.getMessage());
            }
        });
    }

    public void shutdown() throws DbException {
        this.log.debug("Start shutdown of InboundQueue");
        this.multipleQueue.shutdown();
    }

    public void setNextTransmission(long messageDataId, long nextTransmission) {
        this.inboundQueueingDAO.setNextTransmission(messageDataId, nextTransmission);
    }

    public int getTotalMessageCount() {
        return this.multipleQueue.size();
    }

    public void deleteFromInboundQueue(InboundQueueMessage inboundQueueMessage) {
        this.deleteMessageWorkFolder(inboundQueueMessage.getUniqueId());
        this.multipleQueue.remove(inboundQueueMessage);
    }

    public Optional<InboundQueueMessage> deleteFromInboundQueue(long messageDataID) {
        this.deleteMessageWorkFolder(messageDataID);
        return this.multipleQueue.remove(messageDataID).map(value -> (InboundQueueMessage)value);
    }

    private void deleteMessageWorkFolder(long messageDataID) {
        File messageWorkDirectory = new File(this.folders.getWorkInboundFolder(), String.valueOf(messageDataID));
        FileSystemUtils.deleteRecursively((File)messageWorkDirectory);
        this.log.debug("Cleaned up inbound directory for message with id {}", (Object)messageDataID);
    }
}

