/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.queue;

import de.ponton.xmlpipe.queue.EndpointQueue;
import de.ponton.xmlpipe.queue.IQueueMessage;
import de.ponton.xmlpipe.queue.InboundQueueMessage;
import de.ponton.xmlpipe.queue.InboundQueueMessageFactory;
import de.pontonconsulting.xmlpipe.adapter.AdapterInfo;
import de.pontonconsulting.xmlpipe.adapter.AdapterRegistry;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.tables.InboundQueueingDAO;
import jakarta.annotation.Nullable;
import jakarta.persistence.EntityManager;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InboundEndpointQueue
implements EndpointQueue {
    private final Logger log = LogManager.getLogger((String)("Messenger." + this.getClass().getSimpleName()));
    private final Queue<IQueueMessage> inTransit;
    private final Supplier<Integer> inTransitLimit;
    private final long maxIdleTime;
    private final AtomicLong timeOfLastAddedMessage;
    private final String endpoint;
    private final InboundQueueingDAO inboundQueueingDAO;
    private final AdapterRegistry adapterRegistry;
    private final InboundQueueMessageFactory inboundQueueMessageFactory;

    public InboundEndpointQueue(String endpoint, Supplier<Integer> inTransitLimit, long maxIdleTime, InboundQueueingDAO inboundQueueingDAO, AdapterRegistry adapterRegistry, InboundQueueMessageFactory inboundQueueMessageFactory) {
        this.endpoint = endpoint;
        this.inTransitLimit = inTransitLimit;
        this.maxIdleTime = maxIdleTime;
        this.inboundQueueingDAO = inboundQueueingDAO;
        this.adapterRegistry = adapterRegistry;
        this.inboundQueueMessageFactory = inboundQueueMessageFactory;
        this.inTransit = new ConcurrentLinkedQueue<IQueueMessage>();
        this.timeOfLastAddedMessage = new AtomicLong(System.currentTimeMillis());
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public void updateTimeOfLastAddedMessage() {
        this.timeOfLastAddedMessage.set(System.currentTimeMillis());
    }

    @Override
    public boolean offer(IQueueMessage queueMessage) {
        this.updateTimeOfLastAddedMessage();
        try {
            if (queueMessage instanceof InboundQueueMessage) {
                InboundQueueMessage inboundQueueMessage = (InboundQueueMessage)queueMessage;
                if (inboundQueueMessage.isInDelivery()) {
                    inboundQueueMessage.deliveryFinished();
                    this.log.debug("Message is already in delivery. Add it to 'inTransit' queue of '{}' directly", (Object)this.endpoint);
                    this.inTransit.add(inboundQueueMessage);
                } else {
                    this.inboundQueueingDAO.addToInboundQueue(inboundQueueMessage);
                    this.log.info("Added message to InboundQueue of '{}' in database", (Object)this.endpoint);
                }
            }
            return false;
        }
        catch (DbException e) {
            throw new IllegalStateException("Can't offer inbound message to queue", e);
        }
    }

    @Override
    public Optional<IQueueMessage> nextMessage() {
        Optional<Long> nextMessageId;
        this.log.trace("Try to get next message from queue {}", (Object)this.endpoint);
        for (int i = 0; i < this.inTransit.size(); ++i) {
            Optional<IQueueMessage> queueMessage = Optional.ofNullable(this.inTransit.poll());
            if (!queueMessage.isPresent()) continue;
            this.inTransit.offer(queueMessage.get());
            if (!queueMessage.get().canBeSent()) continue;
            this.log.debug("Start transit of InboundMessage of queue {}", (Object)this.endpoint);
            this.inboundQueueingDAO.setNextTransmission(queueMessage.get().getUniqueId(), null);
            return queueMessage;
        }
        if (this.hasCapacity() && this.isEndpointUp() && (nextMessageId = this.inboundQueueingDAO.startTransferOfNextPendingMessage(this.endpoint)).isPresent()) {
            this.log.trace("Next message found in database for endpoint {}", (Object)this.endpoint);
            InboundQueueMessage newQueueMessage = this.inboundQueueMessageFactory.create(null, nextMessageId.get(), this.endpoint);
            this.inTransit.offer(newQueueMessage);
            this.log.debug("Moved message to transit queue '{}'. Transit queue size: {}. Transit limit: {}.", (Object)this.endpoint, (Object)this.inTransit.size(), (Object)this.inTransitLimit.get());
            return Optional.of(newQueueMessage);
        }
        this.log.trace("InboundMessageQueue {} is empty.", (Object)this.endpoint);
        return Optional.empty();
    }

    private boolean isEndpointUp() {
        boolean isEndpointUp;
        AdapterInfo adapterInfo = this.adapterRegistry.getAdapter(this.endpoint);
        if (adapterInfo == null) {
            this.log.error("No registered adapter found for {}", (Object)this.endpoint);
            return false;
        }
        boolean bl = isEndpointUp = !adapterInfo.isDown();
        if (!isEndpointUp) {
            this.log.debug("Endpoint {} is down", (Object)this.endpoint);
        }
        return isEndpointUp;
    }

    @Override
    public boolean hasCapacity() {
        boolean hasCapacity = this.inTransit.size() < this.inTransitLimit.get();
        this.log.trace("Endpoint {} has capacity: {} (inTransit.size={} / inTransitLimit={})", (Object)this.endpoint, (Object)hasCapacity, (Object)this.inTransit.size(), (Object)this.inTransitLimit.get());
        return hasCapacity;
    }

    @Override
    public boolean remove(IQueueMessage queueMessage) {
        boolean deletedFromDB;
        try {
            this.log.trace("Try to remove message from queue {}", (Object)this.endpoint);
            deletedFromDB = this.inboundQueueingDAO.deleteFromInboundQueue(queueMessage.getUniqueId());
        }
        catch (DbException e) {
            this.log.error("Can't delete message from queue {}: {}", (Object)this.endpoint, (Object)e.getMessage());
            return false;
        }
        boolean removedFromInTransit = this.inTransit.remove(queueMessage);
        if (removedFromInTransit || deletedFromDB) {
            this.log.info("Removed message from queue '{}' (inTransit={} / database={}).", (Object)this.endpoint, (Object)removedFromInTransit, (Object)deletedFromDB);
            return true;
        }
        this.log.warn("Message to remove not found in {} queue", (Object)this.endpoint);
        return false;
    }

    @Override
    public int size() {
        int size = this.inboundQueueingDAO.getQueueSize(this.endpoint);
        this.log.trace("Size of queue {}: {}", (Object)this.endpoint, (Object)size);
        return size;
    }

    @Override
    public boolean canBeDeleted() {
        if (!this.inTransit.isEmpty()) {
            return false;
        }
        return System.currentTimeMillis() - this.timeOfLastAddedMessage.get() > this.maxIdleTime;
    }

    @Override
    public Optional<IQueueMessage> removeById(long messageUniqueId) {
        return this.removeById(messageUniqueId, null);
    }

    @Override
    public Optional<IQueueMessage> removeById(long messageUniqueId, @Nullable EntityManager entityManage) {
        boolean deleted = this.deleteFromInboundQueue(messageUniqueId, entityManage);
        Optional<IQueueMessage> queueMessage = this.inTransit.stream().filter(iq -> iq.getUniqueId() == messageUniqueId).findFirst();
        queueMessage.ifPresent(this.inTransit::remove);
        this.log.debug(queueMessage.isPresent() ? "Message removed from 'in transit' queue" : "Message not found in 'in transit' queue");
        if (queueMessage.isEmpty() && deleted) {
            queueMessage = Optional.ofNullable(this.inboundQueueMessageFactory.create(null, messageUniqueId, null));
        }
        return queueMessage;
    }

    private boolean deleteFromInboundQueue(long messageUniqueId, @Nullable EntityManager entityManage) {
        boolean deleted;
        this.log.trace("Try to delete message from InboundQueue in database");
        try {
            deleted = Objects.nonNull(entityManage) ? this.inboundQueueingDAO.deleteFromInboundQueue(messageUniqueId, entityManage) : this.inboundQueueingDAO.deleteFromInboundQueue(messageUniqueId);
        }
        catch (DbException e) {
            this.log.error("Message can't be deleted from queue in database: {}", (Object)e.getMessage());
            deleted = true;
        }
        this.log.debug(deleted ? "Message deleted from InboundQueue in database" : "Message not found in InboundQueue in database");
        return deleted;
    }
}

