/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.notification;

import de.pontonconsulting.xmlpipe.config.SystemEvent;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.PartnerCertificateData;
import de.pontonconsulting.xmlpipe.messenger.database.tables.PartnerProfileDAO;
import de.pontonconsulting.xmlpipe.messenger.emailnotification.SystemEventNotifier;
import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateExpirationNotificationService
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(CertificateExpirationNotificationService.class);
    private final ScheduledExecutorService scheduledExecutorService;
    private final PartnerProfileDAO partnerProfileDAO;
    private final SystemEventNotifier systemEventNotifier;
    private final ReferenceDateTask referenceDateTask;
    private ScheduledFuture<?> scheduledTask;

    public CertificateExpirationNotificationService(ScheduledExecutorService scheduledExecutorService, PartnerProfileDAO partnerProfileDAO, SystemEventNotifier systemEventNotifier, ReferenceDateTask referenceDateTask) {
        this.scheduledExecutorService = scheduledExecutorService;
        this.partnerProfileDAO = partnerProfileDAO;
        this.systemEventNotifier = systemEventNotifier;
        this.referenceDateTask = referenceDateTask;
    }

    public synchronized void start() {
        if (this.scheduledTask == null) {
            this.scheduledTask = this.scheduledExecutorService.scheduleAtFixedRate(this, 1L, 1440L, TimeUnit.MINUTES);
        }
    }

    public void stop() {
        if (this.scheduledTask != null) {
            this.scheduledTask.cancel(true);
        }
    }

    @Override
    public void run() {
        List<PartnerCertificateData> allPartnerCertificates = this.partnerProfileDAO.getAllPartnerCertificates();
        allPartnerCertificates.forEach(partnerCertificateData -> {
            if (this.referenceDateTask.getReferenceOffsetDateTime().plusDays(30L).toLocalDate().isEqual(partnerCertificateData.getValidTo().toLocalDate())) {
                this.notifyIncomingExpiration((PartnerCertificateData)partnerCertificateData);
            } else if (this.referenceDateTask.getReferenceOffsetDateTime().toLocalDate().isEqual(partnerCertificateData.getValidTo().toLocalDate())) {
                try {
                    this.notifyExpired((PartnerCertificateData)partnerCertificateData);
                }
                catch (Exception e) {
                    this.logger.warn("Error notifying expired certificate for partner ID {}: {}", (Object)partnerCertificateData.getPartnerId(), (Object)e.getMessage());
                }
            }
        });
    }

    private void notifyIncomingExpiration(PartnerCertificateData partnerCertificateData) {
        this.partnerProfileDAO.getPartnerProfile(partnerCertificateData.getPartnerId()).ifPresent(partnerProfile -> this.systemEventNotifier.sendNotification(partnerProfile.isRemote() ? SystemEvent.REMOTE_PARTNER_CERTIFICATE_EXPIRATION_WARNING : SystemEvent.LOCAL_PARTNER_CERTIFICATE_EXPIRATION_WARNING, MessageFormat.format("Certificate {0} for {1} Partner: {2} will expire in 30 days.", partnerCertificateData.getSubjectDn(), partnerProfile.isRemote() ? "Remote" : "Local", partnerProfile.getDisplayName())));
    }

    private void notifyExpired(PartnerCertificateData partnerCertificateData) throws Exception {
        this.partnerProfileDAO.getPartnerProfile(partnerCertificateData.getPartnerId()).ifPresent(partnerProfile -> this.systemEventNotifier.sendNotification(partnerProfile.isRemote() ? SystemEvent.REMOTE_PARTNER_CERTIFICATE_EXPIRED_ERROR : SystemEvent.LOCAL_PARTNER_CERTIFICATE_EXPIRED_ERROR, MessageFormat.format("Certificate {0} for {1} Partner: {2} has expired.", partnerCertificateData.getSubjectDn(), partnerProfile.isRemote() ? "Remote" : "Local", partnerProfile.getDisplayName())));
    }
}

