/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.api.websocket;

import de.ponton.api.WebSocketAdapterInfo;
import de.ponton.api.websocket.WebSocketAdapterAccessException;
import de.ponton.api.websocket.WebSocketConnection;
import de.pontonconsulting.xmlpipe.adapter.MessageResult;
import de.pontonconsulting.xmlpipe.messenger.adapter.AdapterCustomException;
import de.pontonconsulting.xmlpipe.messenger.adapter.AdapterRejectedMessageException;
import de.pontonconsulting.xmlpipe.messenger.adapter.IAdapterAccess;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.XpInboundMessage;
import java.io.File;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WebSocketAdapterAccess
implements IAdapterAccess {
    private static final Logger LOG = LogManager.getLogger((String)"Messenger.WebSocketAdapterAccess");
    private final WebSocketAdapterInfo info;

    public WebSocketAdapterAccess(WebSocketAdapterInfo info) {
        this.info = info;
    }

    @Override
    public boolean isSelfCheckOk() {
        return !this.info.isDown();
    }

    @Override
    public String getStatusMessage() {
        return this.info.getStatus();
    }

    @Override
    public void partnerAdded(String internalId, String displayName, boolean isLocal) {
    }

    @Override
    public void partnerModifed(String internalId, String oldInternalId, String displayName, boolean isLocal) {
    }

    @Override
    public void partnerDeleted(String internalId, String displayName, boolean isLocal) {
    }

    @Override
    public void agreementAdded(String localPartnerId, String remotePartnerId) {
    }

    @Override
    public void agreementModified(String localPartnerId, String remotePartnerId) {
    }

    @Override
    public void agreementDeleted(String localPartnerId, String remotePartnerId) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageResult sendInboundDocument(XpInboundMessage xpInboundMessage, File workInboundFolder) throws WebSocketAdapterAccessException, AdapterRejectedMessageException, AdapterCustomException, InterruptedException {
        WebSocketConnection connection = this.info.borrowInboundConnection();
        try {
            MessageResult result;
            if (xpInboundMessage.isAck()) {
                result = this.sendStatusUpdate(xpInboundMessage, connection);
            } else if (xpInboundMessage.isSignal() && xpInboundMessage.isErrorNotification()) {
                result = this.sendErrorNotification(xpInboundMessage, connection);
            } else {
                try {
                    File dataFile = xpInboundMessage.getCurrentContentReference();
                    if (!dataFile.exists()) {
                        LOG.error("[{}] preventing endless xpInboundQueueMessage delivery loop by rejecting the xpInboundQueueMessage. Payload file not found: {}", (Object)xpInboundMessage.getDatabaseId(), (Object)dataFile.getAbsolutePath());
                        MessageResult rejection = new MessageResult(MessageResult.ADAPTER_REJECTED_MESSAGE);
                        rejection.setDescription("File not found: " + dataFile.getAbsolutePath());
                        throw new AdapterRejectedMessageException(rejection);
                    }
                }
                catch (NullPointerException e) {
                    LOG.error("[{}] NullPointerException while sending to Adapter {}: {}", (Object)xpInboundMessage.getDatabaseId(), (Object)xpInboundMessage.getAdapterId(), (Object)e.toString());
                    MessageResult rejection = new MessageResult(MessageResult.ADAPTER_REJECTED_MESSAGE);
                    rejection.setDescription("Payload file not found.");
                    throw new AdapterRejectedMessageException(rejection);
                }
                result = this.sendInboundMessage(xpInboundMessage, connection);
            }
            MessageResult messageResult = result;
            return messageResult;
        }
        finally {
            this.info.releaseInboundConnection(connection);
        }
    }

    private MessageResult sendErrorNotification(XpInboundMessage xpInboundMessage, WebSocketConnection connection) throws AdapterRejectedMessageException, WebSocketAdapterAccessException {
        MessageResult result = connection.sendErrorNotification(xpInboundMessage);
        if (result.equals((Object)MessageResult.ADAPTER_REJECTED_MESSAGE)) {
            throw new AdapterRejectedMessageException(result);
        }
        if (result.equals((Object)MessageResult.COULD_NOT_PROCESS_MESSAGE)) {
            throw new WebSocketAdapterAccessException(result);
        }
        return result;
    }

    private MessageResult sendStatusUpdate(XpInboundMessage xpInboundMessage, WebSocketConnection connection) throws AdapterRejectedMessageException, WebSocketAdapterAccessException {
        MessageResult result = connection.sendFinalStatusUpdate(xpInboundMessage);
        if (result.equals((Object)MessageResult.ADAPTER_REJECTED_MESSAGE)) {
            throw new AdapterRejectedMessageException(result);
        }
        if (result.equals((Object)MessageResult.COULD_NOT_PROCESS_MESSAGE)) {
            throw new WebSocketAdapterAccessException(result);
        }
        return result;
    }

    private MessageResult sendInboundMessage(XpInboundMessage message, WebSocketConnection connection) throws AdapterRejectedMessageException, AdapterCustomException, WebSocketAdapterAccessException, InterruptedException {
        MessageResult result = connection.sendInboundMessage(message);
        if (result.equals((Object)MessageResult.ADAPTER_REJECTED_MESSAGE)) {
            throw new AdapterRejectedMessageException(result);
        }
        if (result.equals((Object)MessageResult.CUSTOM_ERROR)) {
            throw new AdapterCustomException(result);
        }
        if (result.equals((Object)MessageResult.COULD_NOT_PROCESS_MESSAGE)) {
            throw new WebSocketAdapterAccessException(result);
        }
        return result;
    }

    @Override
    public void partnerCertificateAdded(String internalId, Object certificate, boolean isLocal) {
    }

    @Override
    public void partnerCertificateDeleted(String internalId, Object certificateId, boolean isLocal) {
    }
}

